#ifndef __MATRIX_H
#define __MATRIX_H

#include "Vector.H"


template <int nCols,int nRows,class T = double>
class Matrix
{
private:
  Vector<nRows,T> cols[nCols];

public:
  Matrix(void)
  {
  }
  
  Matrix(const Matrix& mat)
  {
    for(int i = 0 ; i < nCols ; i++)
      cols[i] = mat.cols[i];
  }
  
  Matrix(const Vector<nRows,T>* vecs)
  {
    for(int i = 0 ; i < nCols ; i++)
      cols[i] = vecs[i];
  }
  
  

  Matrix operator-(void) const
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans.cols[i] = -cols[i];
  
    return ans;
  }
  
  
  Matrix operator+(const Matrix& mat) const
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans.cols[i] = cols[i] + mat.cols[i];
  
    return ans;
  }
  
  Matrix operator-(const Matrix& mat) const
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans.cols[i] = cols[i] - mat.cols[i];
  
    return ans;
  }
  
  
  Matrix operator*(const T& scalar) const
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans[i] = cols[i] * scalar;
  
    return ans;
  }
  
  Matrix operator/(const T& scalar) const
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans[i] = cols[i] / scalar;
  
    return ans;
  }
  
  
  friend Matrix operator*(const T& scalar,const Matrix& mat)
  {
    Matrix ans;
  
    for(int i = 0 ; i < nCols ; i++)
      ans[i] = scalar * mat.cols[i];
  
    return ans;
  }
  
  
  Vector<nRows,T> operator*(const Vector<nCols,T>& vec) const
  {
    Matrix<1,nCols,T> mat(&vec);
    return ((*this) * mat)[0];
  }
  
  
  Matrix& operator=(const Matrix& mat)
  {
    for(int i = 0 ; i < nCols ; i++)
      cols[i] = mat.cols[i];
  
    return (*this);
  }
  
  
  Matrix& operator+=(const Matrix& mat)
  {
    return ((*this) = (*this) + mat);
  }
  
  Matrix& operator-=(const Matrix& mat)
  {
    return ((*this) = (*this) - mat);
  }
  
  
  Matrix& operator*=(const T& scalar)
  {
    return ((*this) = (*this) * scalar);
  }
  
  Matrix& operator/=(const T& scalar)
  {
    return ((*this) = (*this) / scalar);
  }
  
  
  Matrix& operator*=(const Matrix& mat)
  {
    return ((*this) = (*this) * mat);
  }
  
  
  bool operator==(const Matrix& mat) const
  {
    for(int i = 0 ; i < nCols ; i++)
      if(cols[i] != mat.cols[i])
        return false;
  
    return true;
  }
  
  bool operator!=(const Matrix& mat) const
  {
    return (!((*this) == mat));
  }
  
  
  Vector<nRows,T>& operator[](int idx)
  {
    return cols[idx];
  }
  
  Vector<nRows,T> operator[](int idx) const
  {
    return cols[idx];
  }
  
  T& operator()(int i,int j)
  {
    return cols[i][j];
  }
  
  T operator()(int i,int j) const
  {
    return cols[i][j];
  }
  
  
  

  Matrix<nRows,nCols,T> transpose(void)
  {
    Matrix<nRows,nCols,T> ans;
  
    for(int i = 0 ; i < nCols ; i++)
      for(int j = 0 ; j < nRows ; j++)
        ans[j][i] = cols[i][j];
  
    return ans;
  }
  
  static Matrix identityMatrix(void)
  {
    Matrix ans;
    int dim = min(nRows,nCols);
    for(int i = 0 ; i < dim ; i++)
      ans[i] = Vector<nRows,T>::axis(i);
    for(int i = dim ; i < nCols ; i++)
      ans[i] = Vector<nRows,T>();
  
    return ans;
  }
  
  
};


template<int nCols,int intSize,int nRows,class T>
Matrix<nCols,nRows,T> operator*(const Matrix<intSize,nRows,T>& mat1,
                                const Matrix<nCols,intSize,T>& mat2)
{
  Matrix<nCols,nRows,T> ans;
  for(int i = 0 ; i < nCols ; i++)
    for(int j = 0 ; j < nRows ; j++)
    {
      T acc = 0;
      for(int k = 0 ; k < intSize ; k++)
        acc += mat1[k][j] * mat2[i][k];
      ans[i][j] = acc;
    }

  return ans;
}



#endif // __MATRIX_H
