/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.ImageStack;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concatenator {
    public List<ImagePlus> concatenate(List<ImagePlus> imps) {
        ArrayList<ImagePlus> outputImps = new ArrayList<ImagePlus>();
        for (ImagePlus imp : imps) {
            int width = imp.getWidth();
            int height = imp.getHeight();
            int type = imp.getType();
            int cSize = imp.getNChannels();
            int zSize = imp.getNSlices();
            int tSize = imp.getNFrames();
            boolean append = false;
            for (int k = 0; k < outputImps.size(); ++k) {
                boolean canAppendC;
                ImagePlus outputImp = (ImagePlus)outputImps.get(k);
                int w = outputImp.getWidth();
                int h = outputImp.getHeight();
                int outType = outputImp.getType();
                int c = outputImp.getNChannels();
                int z = outputImp.getNSlices();
                int t = outputImp.getNFrames();
                if (width != w || height != h || type != outType) continue;
                boolean canAppendT = cSize == c && zSize == z;
                boolean canAppendZ = cSize == c && tSize == t;
                boolean bl = canAppendC = zSize == z && tSize == t;
                if (!canAppendT && !canAppendZ && !canAppendC) continue;
                ImageStack outputStack = outputImp.getStack();
                ImageStack inputStack = imp.getStack();
                for (int s = 0; s < inputStack.getSize(); ++s) {
                    outputStack.addSlice(inputStack.getSliceLabel(s + 1), inputStack.getProcessor(s + 1));
                }
                outputImp.setStack(outputImp.getTitle(), outputStack);
                if (canAppendT) {
                    outputImp.setDimensions(c, z, t + tSize);
                } else if (canAppendZ) {
                    outputImp.setDimensions(c, z + zSize, t);
                } else if (canAppendC) {
                    outputImp.setDimensions(c + cSize, z, t);
                } else {
                    throw new IllegalStateException("Dimensional mismatch");
                }
                append = true;
                break;
            }
            if (append) continue;
            outputImps.add(imp);
        }
        return outputImps;
    }
}

