/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.CBZip2InputStream;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLReader
extends FormatReader {
    private static final String NO_OME_JAVA_MSG = "The Java OME-XML library is required to read OME-XML files. Please obtain ome-xml.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noOME = false;
    private Vector<Long> binDataOffsets;
    private Vector<Long> binDataLengths;
    private Vector<String> compression;
    private String omexml;
    private boolean hasSPW = false;

    public OMEXMLReader() {
        super("OME-XML", "ome");
        this.domains = FormatTools.ALL_DOMAINS;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        String xml = stream.readString(64);
        return xml.startsWith("<?xml") && xml.indexOf("<OME") >= 0;
    }

    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_HCS_DOMAINS;
        }
        return stringArray;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = no;
        for (int i = 0; i < this.series; ++i) {
            index += this.core[i].imageCount;
        }
        if (index >= this.binDataOffsets.size()) {
            index = this.binDataOffsets.size() - 1;
        }
        long offset = this.binDataOffsets.get(index);
        long length = this.binDataLengths.get(index);
        String compress = this.compression.get(index);
        this.in.seek(offset - 64L);
        boolean foundBinData = false;
        byte[] check = new byte[8192];
        int overlap = 14;
        int n = this.in.read(check, 0, overlap);
        while (!foundBinData) {
            int r = this.in.read(check, overlap, check.length - overlap);
            if (r <= 0) {
                throw new IOException("Cannot read from input stream");
            }
            n += r;
            String checkString = new String(check);
            int pos = 0;
            while (checkString.indexOf("BinData", pos) != -1 && pos < checkString.length() && pos >= 0) {
                int idx = checkString.indexOf("BinData", pos) + 7;
                pos = idx + 1;
                boolean foundBeginning = false;
                int openBracket = idx;
                while (!foundBeginning && openBracket >= 1) {
                    foundBeginning = checkString.charAt(--openBracket) == '<';
                }
                if (checkString.charAt(openBracket + 1) == '/') continue;
                foundBinData = true;
                this.in.seek(this.in.getFilePointer() - (long)n + (long)idx);
                do {
                    if ((r = this.in.read()) > 0) continue;
                    throw new IOException("EOF looking for terminating > character");
                } while (r != 62);
                if (!foundBinData) continue;
                break;
            }
            if (foundBinData) continue;
            System.arraycopy(check, check.length - overlap, check, 0, overlap);
            n = overlap;
        }
        if (length < 0L && index + 1 < this.binDataOffsets.size()) {
            length = this.binDataOffsets.get(index + 1) - offset;
        } else if (length < 0L) {
            length = this.in.length() - offset;
        }
        int depth = FormatTools.getBytesPerPixel(this.getPixelType());
        int planeSize = this.getSizeX() * this.getSizeY() * depth;
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = depth * 8;
        options.channels = this.getRGBChannelCount();
        options.maxBytes = planeSize;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        byte[] pixels = new Base64Codec().decompress(this.in, options);
        if (compress.equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream(bais);
            pixels = new byte[planeSize];
            bzip.read(pixels, 0, pixels.length);
            tempPixels = null;
            bais.close();
            bais = null;
            bzip = null;
        } else if (compress.equals("zlib")) {
            pixels = new ZlibCodec().decompress(pixels, options);
        } else if (compress.equals("J2K")) {
            pixels = new JPEG2000Codec().decompress(pixels, options);
        } else if (compress.equals("JPEG")) {
            pixels = new JPEGCodec().decompress(pixels, options);
        }
        for (int row = 0; row < h; ++row) {
            int off = (row + y) * this.getSizeX() * depth + x * depth;
            System.arraycopy(pixels, off, buf, row * w * depth, w * depth);
        }
        pixels = null;
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = null;
            this.binDataOffsets = null;
            this.binDataLengths = null;
            this.omexml = null;
            this.hasSPW = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("OMEXMLReader.initFile(" + id + ")");
        if (noOME) {
            throw new MissingLibraryException(NO_OME_JAVA_MSG);
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.binDataOffsets = new Vector();
        this.binDataLengths = new Vector();
        this.compression = new Vector();
        OMEXMLHandler handler = new OMEXMLHandler();
        XMLTools.parseXML(this.in, (DefaultHandler)handler);
        if (this.binDataOffsets.size() == 0) {
            throw new FormatException("Pixel data not found");
        }
        this.status("Populating metadata");
        IMetadata omexmlMeta = MetadataTools.createOMEXMLMetadata(this.omexml);
        if (omexmlMeta == null) {
            throw new FormatException("ome-xml.jar is required to read OME-XML files. Please download it from http://loci.wisc.edu/ome/formats-library.html");
        }
        this.hasSPW = omexmlMeta.getPlateCount() > 0;
        Hashtable<String, String> originalMetadata = MetadataTools.getOriginalMetadata(omexmlMeta);
        if (originalMetadata != null) {
            this.metadata = originalMetadata;
        }
        int numDatasets = omexmlMeta.getImageCount();
        this.core = new CoreMetadata[numDatasets];
        int oldSeries = this.getSeries();
        for (int i = 0; i < numDatasets; ++i) {
            boolean signed;
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            Integer w = omexmlMeta.getPixelsSizeX(i, 0);
            Integer h = omexmlMeta.getPixelsSizeY(i, 0);
            Integer t = omexmlMeta.getPixelsSizeT(i, 0);
            Integer z = omexmlMeta.getPixelsSizeZ(i, 0);
            Integer c = omexmlMeta.getPixelsSizeC(i, 0);
            if (w == null || h == null || t == null || z == null | c == null) {
                throw new FormatException("Image dimensions not found");
            }
            Boolean endian = omexmlMeta.getPixelsBigEndian(i, 0);
            String pixType = omexmlMeta.getPixelsPixelType(i, 0);
            this.core[i].dimensionOrder = omexmlMeta.getPixelsDimensionOrder(i, 0);
            this.core[i].sizeX = w;
            this.core[i].sizeY = h;
            this.core[i].sizeT = t;
            this.core[i].sizeZ = z;
            this.core[i].sizeC = c;
            this.core[i].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            this.core[i].littleEndian = endian == null ? false : endian == false;
            this.core[i].rgb = false;
            this.core[i].interleaved = false;
            this.core[i].indexed = false;
            this.core[i].falseColor = true;
            String type = pixType.toLowerCase();
            boolean bl = signed = type.charAt(0) != 'u';
            this.core[i].pixelType = type.endsWith("16") ? (signed ? 2 : 3) : (type.endsWith("32") ? (signed ? 4 : 5) : (type.equals("float") ? 6 : (signed ? 0 : 1)));
            this.core[i].orderCertain = true;
        }
        this.setSeries(oldSeries);
        MetadataStore store = this.getMetadataStore();
        MetadataTools.convertMetadata(omexmlMeta, store);
    }

    static {
        try {
            Class.forName("ome.xml.OMEXMLNode");
        }
        catch (Throwable t) {
            noOME = true;
            LogTools.traceDebug(t);
        }
    }

    class OMEXMLHandler
    extends DefaultHandler {
        private StringBuffer xmlBuffer = new StringBuffer();
        private long nextBinDataOffset = 0L;
        private String currentQName;
        private boolean hadCharData;
        private int binDataChars;

        public void characters(char[] ch, int start, int length) {
            if (this.currentQName.indexOf("BinData") != -1) {
                this.binDataChars += length;
            }
            this.nextBinDataOffset += (long)length;
            this.hadCharData = true;
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.indexOf("BinData") == -1) {
                this.xmlBuffer.append("</");
                this.xmlBuffer.append(qName);
                this.xmlBuffer.append(">");
            } else {
                OMEXMLReader.this.binDataOffsets.add(new Long(this.nextBinDataOffset - (long)this.binDataChars));
            }
            this.nextBinDataOffset += 2L;
            if (!qName.equals(this.currentQName) || this.hadCharData) {
                this.nextBinDataOffset += (long)qName.length();
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.nextBinDataOffset += (long)length;
        }

        public void startElement(String ur, String localName, String qName, Attributes attributes) {
            int i;
            this.hadCharData = false;
            this.currentQName = qName;
            if (qName.indexOf("BinData") == -1) {
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (i = 0; i < attributes.getLength(); ++i) {
                    String key = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            } else {
                String length = attributes.getValue("Length");
                if (length == null) {
                    OMEXMLReader.this.binDataLengths.add(new Long(-1L));
                } else {
                    OMEXMLReader.this.binDataLengths.add(new Long(length));
                }
                String compress = attributes.getValue("Compression");
                OMEXMLReader.this.compression.add(compress == null ? "" : compress);
                this.binDataChars = 0;
            }
            this.nextBinDataOffset += (long)(2 + qName.length() + 4 * attributes.getLength());
            for (i = 0; i < attributes.getLength(); ++i) {
                this.nextBinDataOffset += (long)attributes.getQName(i).length();
                this.nextBinDataOffset += (long)attributes.getValue(i).length();
            }
        }

        public void endDocument() {
            OMEXMLReader.this.omexml = this.xmlBuffer.toString();
        }
    }
}

