/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphReader
extends BaseTiffReader {
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String MEDIUM_DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    public static final String LONG_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss:SSS";
    public static final String[] ND_SUFFIX = new String[]{"nd"};
    public static final String[] STK_SUFFIX = new String[]{"stk", "tif", "tiff"};
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private double[] wave;
    private String binning;
    private double zoom;
    private double stepSize;
    private Float exposureTime;
    private Vector<String> waveNames;
    private Vector<String> stageNames;
    private long[] internalStamps;
    private double[] zDistances;
    private double[] stageX;
    private double[] stageY;
    private int mmPlanes;
    private MetamorphReader stkReader;
    private String[][] stks;
    private String ndFilename;
    private boolean canLookForND = true;
    private boolean[] firstSeriesChannels;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !MetamorphReader.checkSuffix(id, ND_SUFFIX);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        String[] files = l.getParentFile().list();
        for (int i = 0; i < files.length; ++i) {
            if (!MetamorphReader.checkSuffix(files[i], ND_SUFFIX) || !id.startsWith(files[i].substring(0, files[i].lastIndexOf(".")))) continue;
            return 0;
        }
        return 2;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (!noPixels && this.stks == null) {
            return new String[]{this.currentId};
        }
        if (this.stks == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        if (this.ndFilename != null) {
            v.add(this.ndFilename);
        }
        if (!noPixels) {
            v.addAll(Arrays.asList(this.stks[this.getSeries()]));
        }
        return v.toArray(new String[v.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        String file2;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.getSizeZ());
        int ndx = no / this.getSizeZ();
        if (this.stks[this.series].length == 1) {
            ndx = 0;
        }
        if ((file2 = this.stks[this.series][ndx]) == null) {
            return buf;
        }
        if (this.stkReader == null) {
            this.stkReader = new MetamorphReader();
            this.stkReader.setCanLookForND(false);
        }
        this.stkReader.setId(file2);
        int plane = this.stks[this.series].length == 1 ? no : coords[0];
        this.stkReader.openBytes(plane, buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.stkReader != null) {
            this.stkReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.stkReader = null;
            this.imageCreationDate = null;
            this.imageName = null;
            this.emWavelength = null;
            this.stks = null;
            this.mmPlanes = 0;
            this.ndFilename = null;
            this.wave = null;
            this.binning = null;
            this.stepSize = 0.0;
            this.zoom = 0.0;
            this.exposureTime = null;
            this.stageNames = null;
            this.waveNames = null;
            this.internalStamps = null;
            this.stageY = null;
            this.stageX = null;
            this.zDistances = null;
            this.canLookForND = true;
            this.firstSeriesChannels = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            this.status("Initializing " + id);
            String stkFile = id.substring(0, id.lastIndexOf("."));
            if (stkFile.indexOf(File.separator) != -1) {
                stkFile = stkFile.substring(stkFile.lastIndexOf(File.separator) + 1);
            }
            String parentPath = id.substring(0, id.lastIndexOf(File.separator) + 1);
            Location parent = new Location(parentPath).getAbsoluteFile();
            this.status("Looking for STK file in " + parent.getAbsolutePath());
            String[] dirList = parent.list();
            for (int i = 0; i < dirList.length; ++i) {
                if (dirList[i].indexOf(stkFile) == -1 || !MetamorphReader.checkSuffix(dirList[i], STK_SUFFIX)) continue;
                stkFile = new Location(parent.getAbsolutePath(), dirList[i]).getAbsolutePath();
                break;
            }
            if (!MetamorphReader.checkSuffix(stkFile, STK_SUFFIX)) {
                throw new FormatException("STK file not found in " + parent.getAbsolutePath() + ".");
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            ndfile = new Location(id);
        } else if (this.canLookForND) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = parent.list();
            for (int i = 0; i < list.length; ++i) {
                String prefix;
                if (!MetamorphReader.checkSuffix(list[i], ND_SUFFIX) || !this.currentId.startsWith(prefix = list[i].substring(0, list[i].lastIndexOf(".")))) continue;
                ndfile = new Location(parent, list[i]).getAbsoluteFile();
                break;
            }
        }
        String creationTime = null;
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            int f;
            int i;
            int i2;
            this.ndFilename = ndfile.getAbsolutePath();
            RandomAccessInputStream ndStream = new RandomAccessInputStream(this.ndFilename);
            String line = ndStream.readLine().trim();
            int zc = this.getSizeZ();
            int cc = this.getSizeC();
            int tc = this.getSizeT();
            int nstages = 0;
            String z = null;
            String c = null;
            String t = null;
            Vector<Boolean> hasZ = new Vector<Boolean>();
            this.waveNames = new Vector();
            this.stageNames = new Vector();
            boolean useWaveNames = true;
            while (!line.equals("\"EndFile\"")) {
                String key = line.substring(1, line.indexOf(",") - 1).trim();
                String value = line.substring(line.indexOf(",") + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("NZSteps")) {
                    z = value;
                } else if (key.equals("NWavelengths")) {
                    c = value;
                } else if (key.equals("NTimePoints")) {
                    t = value;
                } else if (key.startsWith("WaveDoZ")) {
                    hasZ.add(new Boolean(value.toLowerCase()));
                } else if (key.startsWith("WaveName")) {
                    this.waveNames.add(value);
                } else if (key.startsWith("Stage")) {
                    this.stageNames.add(value);
                } else if (key.startsWith("StartTime")) {
                    creationTime = value;
                } else if (key.equals("ZStepSize")) {
                    this.stepSize = Float.parseFloat(value);
                } else if (key.equals("NStagePositions")) {
                    nstages = Integer.parseInt(value);
                } else if (key.equals("WaveInFileName")) {
                    useWaveNames = Boolean.parseBoolean(value);
                }
                line = ndStream.readLine().trim();
            }
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            if (cc == 0) {
                cc = 1;
            }
            int numFiles = cc * tc;
            if (nstages > 0) {
                numFiles *= nstages;
            }
            int seriesCount = nstages == 0 ? 1 : nstages;
            this.firstSeriesChannels = new boolean[cc];
            Arrays.fill(this.firstSeriesChannels, true);
            boolean differentZs = false;
            for (int i3 = 0; i3 < cc; ++i3) {
                boolean hasZ2;
                boolean hasZ1 = i3 < hasZ.size() && (Boolean)hasZ.get(i3) != false;
                boolean bl = hasZ2 = i3 != 0 && i3 - 1 < hasZ.size() && (Boolean)hasZ.get(i3 - 1) != false;
                if (i3 <= 0 || hasZ1 == hasZ2) continue;
                if (!differentZs) {
                    seriesCount *= 2;
                }
                differentZs = true;
            }
            int channelsInFirstSeries = cc;
            if (differentZs) {
                channelsInFirstSeries = 0;
                for (i2 = 0; i2 < cc; ++i2) {
                    if (((Boolean)hasZ.get(i2)).booleanValue()) {
                        ++channelsInFirstSeries;
                        continue;
                    }
                    this.firstSeriesChannels[i2] = false;
                }
            }
            this.stks = new String[seriesCount][];
            if (seriesCount == 1) {
                this.stks[0] = new String[numFiles];
            } else if (differentZs) {
                int stages = nstages == 0 ? 1 : nstages;
                for (i = 0; i < stages; ++i) {
                    this.stks[i * 2] = new String[channelsInFirstSeries * tc];
                    this.stks[i * 2 + 1] = new String[(cc - channelsInFirstSeries) * tc];
                }
            } else {
                for (i2 = 0; i2 < this.stks.length; ++i2) {
                    this.stks[i2] = new String[numFiles / this.stks.length];
                }
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            for (i = 0; i < cc; ++i) {
                if (i >= this.waveNames.size() || this.waveNames.get(i) == null) continue;
                String name = this.waveNames.get(i);
                this.waveNames.setElementAt(name.substring(1, name.length() - 1), i);
            }
            int[] pt = new int[seriesCount];
            for (int i4 = 0; i4 < tc; ++i4) {
                int ns = nstages == 0 ? 1 : nstages;
                for (int s = 0; s < ns; ++s) {
                    for (int j = 0; j < cc; ++j) {
                        boolean validZ = j >= hasZ.size() || (Boolean)hasZ.get(j) != false;
                        int seriesNdx = s * (seriesCount / ns);
                        this.stks[seriesNdx][pt[seriesNdx += seriesCount == 1 || validZ ? 0 : 1]] = prefix;
                        if (j < this.waveNames.size() && this.waveNames.get(j) != null) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_w" + (j + 1);
                            if (useWaveNames) {
                                String[] stringArray2 = this.stks[seriesNdx];
                                int n2 = pt[seriesNdx];
                                stringArray2[n2] = stringArray2[n2] + this.waveNames.get(j);
                            }
                        }
                        if (nstages > 0) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_s" + (s + 1);
                        }
                        if (tc > 1) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_t" + (i4 + 1) + ".STK";
                        } else {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + ".STK";
                        }
                        int n = seriesNdx;
                        pt[n] = pt[n] + 1;
                    }
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s = 0; s < this.stks.length; ++s) {
                for (f = 0; f < this.stks[s].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s][f]);
                    if (!l.exists()) {
                        if (this.stks[s][f].indexOf("%") != -1) {
                            this.stks[s][f] = this.stks[s][f].replaceAll("%", "-");
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                                l = new Location(ndfile.getParent(), this.stks[s][f]);
                                if (!l.exists()) {
                                    this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".tif";
                                    l = new Location(ndfile.getParent(), this.stks[s][f]);
                                    if (!l.exists()) {
                                        this.stks[s][f] = null;
                                    }
                                }
                            }
                        }
                        if (!l.exists()) {
                            this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".tif";
                                l = new Location(ndfile.getParent(), this.stks[s][f]);
                                if (!l.exists()) {
                                    this.stks[s][f] = null;
                                }
                            }
                        }
                    }
                    if (this.stks != null && l.exists()) {
                        this.stks[s][f] = l.getAbsolutePath();
                        continue;
                    }
                    if (this.stks == null) break;
                }
                if (this.stks == null) break;
            }
            int q = 0;
            f = 0;
            String file2 = this.stks[q][f];
            while (file2 == null) {
                if (f < this.stks[q].length - 1) {
                    ++f;
                } else if (q < this.stks.length - 1) {
                    ++q;
                    f = 0;
                }
                file2 = this.stks[q][f];
            }
            RandomAccessInputStream s = new RandomAccessInputStream(file2);
            TiffParser tp = new TiffParser(s);
            IFD ifd = tp.getFirstIFD();
            s.close();
            this.core[0].sizeX = (int)ifd.getImageWidth();
            this.core[0].sizeY = (int)ifd.getImageLength();
            this.core[0].sizeZ = zc;
            this.core[0].sizeC = cc;
            this.core[0].sizeT = tc;
            this.core[0].imageCount = zc * tc * cc;
            this.core[0].dimensionOrder = "XYZCT";
            if (this.stks != null && this.stks.length > 1) {
                CoreMetadata[] newCore = new CoreMetadata[this.stks.length];
                for (int i5 = 0; i5 < this.stks.length; ++i5) {
                    newCore[i5] = new CoreMetadata();
                    newCore[i5].sizeX = this.getSizeX();
                    newCore[i5].sizeY = this.getSizeY();
                    newCore[i5].sizeZ = this.getSizeZ();
                    newCore[i5].sizeC = this.getSizeC();
                    newCore[i5].sizeT = this.getSizeT();
                    newCore[i5].pixelType = this.getPixelType();
                    newCore[i5].imageCount = this.getImageCount();
                    newCore[i5].dimensionOrder = this.getDimensionOrder();
                    newCore[i5].rgb = this.isRGB();
                    newCore[i5].littleEndian = this.isLittleEndian();
                    newCore[i5].interleaved = this.isInterleaved();
                    newCore[i5].orderCertain = true;
                }
                if (this.stks.length > nstages) {
                    int ns = nstages == 0 ? 1 : nstages;
                    for (int j = 0; j < ns; ++j) {
                        newCore[j * 2].sizeC = this.stks[j * 2].length / this.getSizeT();
                        newCore[j * 2 + 1].sizeC = this.stks[j * 2 + 1].length / newCore[j * 2 + 1].sizeT;
                        newCore[j * 2 + 1].sizeZ = 1;
                        newCore[j * 2].imageCount = newCore[j * 2].sizeC * newCore[j * 2].sizeT * newCore[j * 2].sizeZ;
                        newCore[j * 2 + 1].imageCount = newCore[j * 2 + 1].sizeC * newCore[j * 2 + 1].sizeT;
                    }
                }
                this.core = newCore;
            }
        }
        Vector<String> timestamps = null;
        MetamorphHandler handler = null;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            handler = new MetamorphHandler(this.getSeriesMetadata());
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            store.setImageInstrumentRef(instrumentID, i);
            String comment = null;
            if (this.stks != null && this.stks[i][0] != null) {
                RandomAccessInputStream stream = new RandomAccessInputStream(this.stks[i][0]);
                TiffParser tp = new TiffParser(stream);
                IFD ifd = tp.getFirstIFD();
                stream.close();
                comment = ifd.getComment();
            } else {
                comment = ((IFD)this.ifds.get(0)).getComment();
            }
            if (comment != null && comment.startsWith("<MetaData>")) {
                XMLTools.parseXML(comment, (DefaultHandler)handler);
            }
            if (creationTime != null) {
                String date = DateTools.formatDate(creationTime, SHORT_DATE_FORMAT);
                store.setImageCreationDate(date, 0);
            } else if (i > 0) {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            String name = "";
            if (this.stageNames != null && this.stageNames.size() > 0) {
                int stagePosition = i / (this.getSeriesCount() / this.stageNames.size());
                name = name + "Stage " + this.stageNames.get(stagePosition) + "; ";
            }
            if (this.firstSeriesChannels != null) {
                for (int c = 0; c < this.firstSeriesChannels.length; ++c) {
                    if (this.firstSeriesChannels[c] != (i % 2 == 0) || c >= this.waveNames.size()) continue;
                    name = name + this.waveNames.get(c) + "/";
                }
                if (name.length() > 0) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            store.setImageName(name, i);
            store.setImageDescription("", i);
            store.setImagingEnvironmentTemperature(new Float(handler.getTemperature()), i);
            store.setDimensionsPhysicalSizeX(new Float(handler.getPixelSizeX()), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(handler.getPixelSizeY()), i, 0);
            if (this.zDistances != null) {
                this.stepSize = this.zDistances[0];
            }
            store.setDimensionsPhysicalSizeZ(new Float(this.stepSize), i, 0);
            int waveIndex = 0;
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.firstSeriesChannels == null || this.stageNames != null && this.stageNames.size() == this.getSeriesCount()) {
                    waveIndex = c;
                } else if (this.firstSeriesChannels != null) {
                    int s = i % 2;
                    while (this.firstSeriesChannels[waveIndex] == (s == 1) && waveIndex < this.firstSeriesChannels.length) {
                        ++waveIndex;
                    }
                }
                if (this.waveNames != null && waveIndex < this.waveNames.size()) {
                    store.setLogicalChannelName(this.waveNames.get(waveIndex), i, c);
                }
                store.setDetectorSettingsBinning(this.binning, i, c);
                if (handler.getBinning() != null) {
                    store.setDetectorSettingsBinning(handler.getBinning(), i, c);
                }
                if (handler.getReadOutRate() != 0.0f) {
                    store.setDetectorSettingsReadOutRate(new Float(handler.getReadOutRate()), i, c);
                }
                store.setDetectorSettingsDetector(detectorID, i, c);
                if (this.wave != null && waveIndex < this.wave.length && (int)this.wave[waveIndex] >= 1) {
                    store.setLightSourceSettingsWavelength(new Integer((int)this.wave[waveIndex]), i, c);
                    String lightSourceID = MetadataTools.createLSID("LightSource", i, c);
                    store.setLightSourceID(lightSourceID, i, c);
                    store.setLightSourceSettingsLightSource(lightSourceID, i, c);
                    store.setLaserType("Unknown", i, c);
                    store.setLaserLaserMedium("Unknown", i, c);
                }
                ++waveIndex;
            }
            timestamps = handler.getTimestamps();
            for (int t = 0; t < timestamps.size(); ++t) {
                this.addSeriesMeta("timestamp " + t, DateTools.formatDate(timestamps.get(t), MEDIUM_DATE_FORMAT));
            }
            long startDate = 0L;
            if (timestamps.size() > 0) {
                startDate = DateTools.getTime(timestamps.get(0), MEDIUM_DATE_FORMAT);
            }
            Float positionX = new Float(handler.getStagePositionX());
            Float positionY = new Float(handler.getStagePositionY());
            Vector<Float> exposureTimes = handler.getExposures();
            if (exposureTimes.size() == 0) {
                for (int p = 0; p < this.getImageCount(); ++p) {
                    exposureTimes.add(this.exposureTime);
                }
            }
            int lastFile = -1;
            IFD lastIFD = null;
            for (int p = 0; p < this.getImageCount(); ++p) {
                int[] coords = this.getZCTCoords(p);
                Float deltaT = new Float(0.0f);
                Float exposureTime = new Float(0.0f);
                if (coords[2] > 0 && this.stks != null && lastFile >= 0 && this.stks[i][lastFile] != null) {
                    int fileIndex = this.getIndex(0, 0, coords[2]) / this.getSizeZ();
                    if (fileIndex != lastFile) {
                        lastFile = fileIndex;
                        RandomAccessInputStream stream = new RandomAccessInputStream(this.stks[i][lastFile]);
                        TiffParser tp = new TiffParser(stream);
                        lastIFD = tp.getFirstIFD();
                        stream.close();
                    }
                    comment = lastIFD.getComment();
                    handler = new MetamorphHandler(this.getSeriesMetadata());
                    if (comment != null && comment.startsWith("<MetaData>")) {
                        XMLTools.parseXML(comment, (DefaultHandler)handler);
                    }
                    timestamps = handler.getTimestamps();
                    exposureTimes = handler.getExposures();
                }
                int index = 0;
                if (timestamps.size() > 0) {
                    if (coords[2] < timestamps.size()) {
                        index = coords[2];
                    }
                    String stamp = timestamps.get(index);
                    long ms = DateTools.getTime(stamp, MEDIUM_DATE_FORMAT);
                    deltaT = new Float((double)(ms - startDate) / 1000.0);
                } else if (this.internalStamps != null && p < this.internalStamps.length) {
                    long delta = this.internalStamps[p] - this.internalStamps[0];
                    deltaT = new Float((double)delta / 1000.0);
                    if (coords[2] < exposureTimes.size()) {
                        index = coords[2];
                    }
                }
                if (index < exposureTimes.size()) {
                    exposureTime = exposureTimes.get(index);
                }
                store.setPlaneTimingDeltaT(deltaT, i, 0, p);
                store.setPlaneTimingExposureTime(exposureTime, i, 0, p);
                if (this.stageX != null && p < this.stageX.length) {
                    store.setStagePositionPositionX(new Float(this.stageX[p]), i, 0, p);
                }
                if (this.stageY == null || p >= this.stageY.length) continue;
                store.setStagePositionPositionY(new Float(this.stageY[p]), i, 0, p);
            }
        }
        this.setSeries(0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorZoom(new Float(this.zoom), 0, 0);
        if (handler != null && handler.getZoom() != 0.0f) {
            store.setDetectorZoom(new Float(handler.getZoom()), 0, 0);
        }
        store.setDetectorType("Unknown", 0, 0);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String filename;
        super.initStandardMetadata();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 0;
        int rgbChannels = this.getSizeC();
        try {
            TiffIFDEntry uic1tagEntry = this.tiffParser.getFirstIFDEntry(33628);
            TiffIFDEntry uic2tagEntry = this.tiffParser.getFirstIFDEntry(33629);
            TiffIFDEntry uic4tagEntry = this.tiffParser.getFirstIFDEntry(33631);
            this.mmPlanes = uic4tagEntry.getValueCount();
            this.parseUIC2Tags(uic2tagEntry.getValueOffset());
            this.parseUIC4Tags(uic4tagEntry.getValueOffset());
            this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
            this.in.seek(uic4tagEntry.getValueOffset());
        }
        catch (IllegalArgumentException exc) {
            this.traceDebug(exc);
        }
        catch (NullPointerException exc) {
            this.traceDebug(exc);
        }
        catch (IOException exc) {
            this.traceDebug(exc);
        }
        try {
            int check;
            TiffRational[] tiffRationalArray;
            IFD firstIFD = (IFD)this.ifds.get(0);
            long[] uic2 = firstIFD.getIFDLongArray(33629, true);
            this.core[0].imageCount = uic2.length;
            Object entry = firstIFD.getIFDValue(33630);
            if (entry instanceof TiffRational[]) {
                tiffRationalArray = (TiffRational[])entry;
            } else {
                TiffRational[] tiffRationalArray2 = new TiffRational[1];
                tiffRationalArray = tiffRationalArray2;
                tiffRationalArray2[0] = (TiffRational)entry;
            }
            TiffRational[] uic3 = tiffRationalArray;
            this.wave = new double[uic3.length];
            Vector<Double> uniqueWavelengths = new Vector<Double>();
            for (int i = 0; i < uic3.length; ++i) {
                this.wave[i] = uic3[i].doubleValue();
                this.addSeriesMeta("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.wave[i]);
                Double v = new Double(this.wave[i]);
                if (uniqueWavelengths.contains(v)) continue;
                uniqueWavelengths.add(v);
            }
            this.core[0].sizeC *= uniqueWavelengths.size();
            IFDList tempIFDs = new IFDList();
            long[] oldOffsets = firstIFD.getStripOffsets();
            long[] stripByteCounts = firstIFD.getStripByteCounts();
            int rowsPerStrip = (int)firstIFD.getRowsPerStrip()[0];
            int stripsPerImage = this.getSizeY() / rowsPerStrip;
            if (stripsPerImage * rowsPerStrip != this.getSizeY()) {
                ++stripsPerImage;
            }
            if ((check = firstIFD.getPhotometricInterpretation()) == 3) {
                firstIFD.putIFDValue(262, 1);
            }
            this.emWavelength = firstIFD.getIFDLongArray(33630, true);
            for (int i = 0; i < this.getImageCount(); ++i) {
                IFD temp = new IFD(firstIFD);
                long[] newOffsets = new long[stripsPerImage];
                if (stripsPerImage * (i + 1) <= oldOffsets.length) {
                    System.arraycopy(oldOffsets, stripsPerImage * i, newOffsets, 0, stripsPerImage);
                } else {
                    System.arraycopy(oldOffsets, 0, newOffsets, 0, stripsPerImage);
                    long image = stripByteCounts[0] / (long)rowsPerStrip * (long)this.getSizeY();
                    int q = 0;
                    while (q < stripsPerImage) {
                        int n = q++;
                        newOffsets[n] = newOffsets[n] + (long)i * image;
                    }
                }
                temp.put(new Integer(273), newOffsets);
                long[] newByteCounts = new long[stripsPerImage];
                if (stripsPerImage * i < stripByteCounts.length) {
                    System.arraycopy(stripByteCounts, stripsPerImage * i, newByteCounts, 0, stripsPerImage);
                } else {
                    Arrays.fill(newByteCounts, stripByteCounts[0]);
                }
                temp.put(new Integer(279), newByteCounts);
                tempIFDs.add(temp);
            }
            this.ifds = tempIFDs;
        }
        catch (IllegalArgumentException exc) {
            this.traceDebug(exc);
        }
        catch (NullPointerException exc) {
            this.traceDebug(exc);
        }
        catch (FormatException exc) {
            this.traceDebug(exc);
        }
        String descr = ((IFD)this.ifds.get(0)).getComment();
        if (descr != null) {
            String[] lines = descr.split("\n");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                int colon = line.indexOf(": ");
                String descrValue = null;
                if (colon < 0) {
                    if (line.length() <= 0) continue;
                    descrValue = line;
                    continue;
                }
                if (i == 0) {
                    int dot = line.lastIndexOf(".", colon);
                    if (dot >= 0) {
                        descrValue = line.substring(0, dot + 1);
                    }
                    line = line.substring(dot + 1);
                    colon -= dot + 1;
                }
                if (descrValue != null) {
                    sb.append(descrValue);
                    if (!descrValue.endsWith(".")) {
                        sb.append(".");
                    }
                    sb.append("  ");
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 2);
                this.addSeriesMeta(key, value);
                if (!key.equals("Exposure")) continue;
                if (value.indexOf(" ") != -1) {
                    value = value.substring(0, value.indexOf(" "));
                }
                float exposure = Float.parseFloat(value);
                this.exposureTime = new Float(exposure / 1000.0f);
            }
            descr = sb.toString().trim();
            if (descr.equals("")) {
                this.metadata.remove("Comment");
            } else {
                this.addSeriesMeta("Comment", descr);
            }
        }
        this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * (this.getSizeC() / rgbChannels));
        if (this.getSizeT() * this.getSizeZ() * (this.getSizeC() / rgbChannels) != this.getImageCount()) {
            this.core[0].sizeT = 1;
            this.core[0].sizeZ = this.getImageCount() / (this.getSizeC() / rgbChannels);
        }
        if ((filename = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1)).indexOf("_t") != -1 && this.getSizeT() > 1) {
            int z = this.getSizeZ();
            this.core[0].sizeZ = this.getSizeT();
            this.core[0].sizeT = z;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC()) != this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
            this.core[0].sizeT = 1;
            if (!this.isRGB()) {
                this.core[0].sizeC = 1;
            }
        }
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        this.zDistances = new double[this.mmPlanes];
        this.internalStamps = new long[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            if (this.in.getFilePointer() + 8L > this.in.length()) break;
            this.zDistances[i] = this.readRational(this.in).doubleValue();
            this.addSeriesMeta("zDistance[" + iAsString + "]", this.zDistances[i]);
            if (this.zDistances[i] != 0.0) {
                ++this.core[0].sizeZ;
            }
            String cDate = MetamorphReader.decodeDate(this.in.readInt());
            String cTime = MetamorphReader.decodeTime(this.in.readInt());
            this.internalStamps[i] = DateTools.getTime(cDate + " " + cTime, LONG_DATE_FORMAT);
            this.addSeriesMeta("creationDate[" + iAsString + "]", cDate);
            this.addSeriesMeta("creationTime[" + iAsString + "]", cTime);
            this.in.skip(8L);
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        if (this.in.getFilePointer() + 2L >= this.in.length()) {
            return;
        }
        short id = this.in.readShort();
        while (id != 0) {
            switch (id) {
                case 28: {
                    this.readStagePositions();
                    break;
                }
                case 29: {
                    this.readRationals(new String[]{"cameraXChipOffset", "cameraYChipOffset"});
                    break;
                }
                case 37: {
                    this.readStageLabels();
                    break;
                }
                case 40: {
                    this.readRationals(new String[]{"absoluteZ"});
                    break;
                }
                case 41: {
                    this.readAbsoluteZValid();
                }
            }
            id = this.in.readShort();
        }
        this.in.seek(saveLoc);
    }

    private void readStagePositions() throws IOException {
        this.stageX = new double[this.mmPlanes];
        this.stageY = new double[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.stageX[i] = this.readRational(this.in).doubleValue();
            this.stageY[i] = this.readRational(this.in).doubleValue();
            this.addSeriesMeta("stageX[" + pos + "]", this.stageX[i]);
            this.addSeriesMeta("stageY[" + pos + "]", this.stageY[i]);
        }
    }

    private void readRationals(String[] labels) throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            for (int q = 0; q < labels.length; ++q) {
                this.addSeriesMeta(labels[q] + "[" + pos + "]", this.readRational(this.in).doubleValue());
            }
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            this.addSeriesMeta("stageLabel[" + iAsString + "]", this.in.readString(strlen));
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            this.addSeriesMeta("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readInt());
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        for (int i = 0; i < uic1count && this.in.getFilePointer() < this.in.length(); ++i) {
            int currentID = this.in.readInt();
            int valOrOffset = this.in.readInt();
            long lastOffset = this.in.getFilePointer();
            String key = this.getKey(currentID);
            Object value = String.valueOf(valOrOffset);
            block0 : switch (currentID) {
                case 3: {
                    value = valOrOffset != 0 ? "on" : "off";
                    break;
                }
                case 4: 
                case 5: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 38: 
                case 39: {
                    value = this.readRational(this.in, valOrOffset);
                    break;
                }
                case 6: 
                case 25: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    if ((long)num + this.in.getFilePointer() >= this.in.length()) {
                        num = (int)(this.in.length() - this.in.getFilePointer() - 1L);
                    }
                    value = this.in.readString(num);
                    break;
                }
                case 7: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.imageName = this.in.readString(num);
                    value = this.imageName;
                    break;
                }
                case 8: {
                    if (valOrOffset == 1) {
                        value = "inside";
                        break;
                    }
                    if (valOrOffset == 2) {
                        value = "outside";
                        break;
                    }
                    value = "off";
                    break;
                }
                case 17: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.imageCreationDate = thedate + " " + thetime;
                    value = this.imageCreationDate;
                    break;
                }
                case 16: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    value = thedate + " " + thetime;
                    break;
                }
                case 26: {
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    switch (standardLUT) {
                        case 0: {
                            value = "monochrome";
                            break block0;
                        }
                        case 1: {
                            value = "pseudocolor";
                            break block0;
                        }
                        case 2: {
                            value = "Red";
                            break block0;
                        }
                        case 3: {
                            value = "Green";
                            break block0;
                        }
                        case 4: {
                            value = "Blue";
                            break block0;
                        }
                        case 5: {
                            value = "user-defined";
                            break block0;
                        }
                    }
                    value = "monochrome";
                    break;
                }
                case 34: {
                    value = String.valueOf(this.in.readInt());
                    break;
                }
                case 46: {
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.binning = xBin + "x" + yBin;
                    value = this.binning;
                }
            }
            this.addSeriesMeta(key, value);
            this.in.seek(lastOffset);
            if (!"Zoom".equals(key) || value == null) continue;
            this.zoom = Float.parseFloat(value.toString());
        }
        this.in.seek(saveLoc);
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return MetamorphReader.intFormat(day, 2) + "/" + MetamorphReader.intFormat(month, 2) + "/" + year;
    }

    public static String decodeTime(int millis) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        time.setTimeInMillis(millis);
        String hours = MetamorphReader.intFormat(time.get(11), 2);
        String minutes = MetamorphReader.intFormat(time.get(12), 2);
        String seconds = MetamorphReader.intFormat(time.get(13), 2);
        String ms = MetamorphReader.intFormat(time.get(14), 3);
        return hours + ":" + minutes + ":" + seconds + ":" + ms;
    }

    public static String intFormat(int myint, int digits) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumIntegerDigits(digits);
        df.setMinimumIntegerDigits(digits);
        return df.format(myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, String.valueOf(maxint).length());
    }

    private TiffRational readRational(RandomAccessInputStream s) throws IOException {
        return this.readRational(s, s.getFilePointer());
    }

    private TiffRational readRational(RandomAccessInputStream s, long offset) throws IOException {
        s.seek(offset);
        int num = s.readInt();
        int denom = s.readInt();
        return new TiffRational(num, denom);
    }

    private void setCanLookForND(boolean v) {
        FormatTools.assertId(this.currentId, false, 1);
        this.canLookForND = v;
    }

    private String getKey(int id) {
        switch (id) {
            case 1: {
                return "MinScale";
            }
            case 2: {
                return "MaxScale";
            }
            case 3: {
                return "Spatial Calibration";
            }
            case 4: {
                return "XCalibration";
            }
            case 5: {
                return "YCalibration";
            }
            case 6: {
                return "CalibrationUnits";
            }
            case 7: {
                return "Name";
            }
            case 8: {
                return "ThreshState";
            }
            case 9: {
                return "ThreshStateRed";
            }
            case 11: {
                return "ThreshStateGreen";
            }
            case 12: {
                return "ThreshStateBlue";
            }
            case 13: {
                return "ThreshStateLo";
            }
            case 14: {
                return "ThreshStateHi";
            }
            case 15: {
                return "Zoom";
            }
            case 16: {
                return "DateTime";
            }
            case 17: {
                return "LastSavedTime";
            }
            case 18: {
                return "currentBuffer";
            }
            case 19: {
                return "grayFit";
            }
            case 20: {
                return "grayPointCount";
            }
            case 21: {
                return "grayX";
            }
            case 22: {
                return "gray";
            }
            case 23: {
                return "grayMin";
            }
            case 24: {
                return "grayMax";
            }
            case 25: {
                return "grayUnitName";
            }
            case 26: {
                return "StandardLUT";
            }
            case 27: {
                return "Wavelength";
            }
            case 30: {
                return "OverlayMask";
            }
            case 31: {
                return "OverlayCompress";
            }
            case 32: {
                return "Overlay";
            }
            case 33: {
                return "SpecialOverlayMask";
            }
            case 34: {
                return "SpecialOverlayCompress";
            }
            case 35: {
                return "SpecialOverlay";
            }
            case 36: {
                return "ImageProperty";
            }
            case 38: {
                return "AutoScaleLoInfo";
            }
            case 39: {
                return "AutoScaleHiInfo";
            }
            case 42: {
                return "Gamma";
            }
            case 43: {
                return "GammaRed";
            }
            case 44: {
                return "GammaGreen";
            }
            case 45: {
                return "GammaBlue";
            }
            case 46: {
                return "CameraBin";
            }
        }
        return null;
    }
}

