/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataStore;

public abstract class DelegateReader
extends FormatReader {
    protected boolean useLegacy;
    protected IFormatReader nativeReader;
    protected IFormatReader legacyReader;
    protected boolean nativeReaderInitialized;
    protected boolean legacyReaderInitialized;

    public DelegateReader(String format, String suffix) {
        super(format, suffix);
    }

    public DelegateReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void setLegacy(boolean legacy) {
        this.useLegacy = legacy;
    }

    public boolean isLegacy() {
        return this.useLegacy;
    }

    public boolean isThisType(String name, boolean open) {
        return this.nativeReader.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.nativeReader.isThisType(stream);
    }

    public void setSeries(int no) {
        super.setSeries(no);
        if (this.nativeReaderInitialized) {
            this.nativeReader.setSeries(no);
        }
        if (this.legacyReaderInitialized) {
            this.legacyReader.setSeries(no);
        }
    }

    public void setNormalized(boolean normalize) {
        super.setNormalized(normalize);
        this.nativeReader.setNormalized(normalize);
        this.legacyReader.setNormalized(normalize);
    }

    public void setMetadataCollected(boolean collect) {
        super.setMetadataCollected(collect);
        this.nativeReader.setMetadataCollected(collect);
        this.legacyReader.setMetadataCollected(collect);
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        super.setOriginalMetadataPopulated(populate);
        this.nativeReader.setOriginalMetadataPopulated(populate);
        this.legacyReader.setOriginalMetadataPopulated(populate);
    }

    public void setGroupFiles(boolean group) {
        super.setGroupFiles(group);
        this.nativeReader.setGroupFiles(group);
        this.legacyReader.setGroupFiles(group);
    }

    public void setMetadataFiltered(boolean filter) {
        super.setMetadataFiltered(filter);
        this.nativeReader.setMetadataFiltered(filter);
        this.legacyReader.setMetadataFiltered(filter);
    }

    public void setMetadataStore(MetadataStore store) {
        super.setMetadataStore(store);
        this.nativeReader.setMetadataStore(store);
        this.legacyReader.setMetadataStore(store);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.useLegacy || this.legacyReaderInitialized && !this.nativeReaderInitialized) {
            return this.legacyReader.openBytes(no, buf, x, y, w, h);
        }
        return this.nativeReader.openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.nativeReader != null) {
            this.nativeReader.close(fileOnly);
        }
        if (this.legacyReader != null) {
            this.legacyReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.legacyReaderInitialized = false;
            this.nativeReaderInitialized = false;
        }
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (this.useLegacy) {
            try {
                this.legacyReader.setId(id);
                this.legacyReaderInitialized = true;
            }
            catch (FormatException e) {
                this.traceDebug(e);
                this.nativeReader.setId(id);
                this.nativeReaderInitialized = true;
            }
        } else {
            Exception exc = null;
            try {
                this.nativeReader.setId(id);
                this.nativeReaderInitialized = true;
            }
            catch (FormatException e) {
                exc = e;
            }
            catch (IOException e) {
                exc = e;
            }
            if (exc != null) {
                this.traceDebug(exc);
                this.legacyReader.setId(id);
                this.legacyReaderInitialized = true;
            }
        }
        if (this.nativeReaderInitialized) {
            this.core = this.nativeReader.getCoreMetadata();
            this.metadata = this.nativeReader.getGlobalMetadata();
            this.metadataStore = this.nativeReader.getMetadataStore();
        }
        if (this.legacyReaderInitialized) {
            this.core = this.legacyReader.getCoreMetadata();
            this.metadata = this.legacyReader.getGlobalMetadata();
            this.metadataStore = this.legacyReader.getMetadataStore();
        }
    }
}

