/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ReaderWrapper;

public class ChannelMerger
extends ReaderWrapper {
    public static ChannelMerger makeChannelMerger(IFormatReader r) {
        if (r instanceof ChannelMerger) {
            return (ChannelMerger)r;
        }
        return new ChannelMerger(r);
    }

    public ChannelMerger() {
    }

    public ChannelMerger(IFormatReader r) {
        super(r);
    }

    public boolean canMerge() {
        int c = this.getSizeC();
        return c > 1 && c <= 4 && !this.reader.isRGB();
    }

    public int getOriginalIndex(int no) throws FormatException, IOException {
        int originalCount;
        int imageCount = this.getImageCount();
        if (imageCount == (originalCount = this.reader.getImageCount())) {
            return no;
        }
        int[] coords = this.getZCTCoords(no);
        return this.reader.getIndex(coords[0], coords[1], coords[2]);
    }

    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int no = this.reader.getImageCount();
        if (this.canMerge()) {
            no /= this.getSizeC();
        }
        return no;
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = this.reader.getDimensionOrder();
        if (this.canMerge()) {
            StringBuffer sb = new StringBuffer(order);
            while (order.indexOf("C") != 2) {
                char pre = order.charAt(order.indexOf("C") - 1);
                sb.setCharAt(order.indexOf("C"), pre);
                sb.setCharAt(order.indexOf(pre), 'C');
                order = sb.toString();
            }
        }
        return order;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.canMerge() || this.reader.isRGB();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return !this.canMerge() && this.reader.isIndexed();
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] newBuffer = new byte[w * h * ch * bpp];
        return this.openBytes(no, newBuffer, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (!this.canMerge()) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int sizeC = this.getSizeC();
        int[] nos = this.getZCTCoords(no);
        int z = nos[0];
        int t = nos[2];
        for (int c = 0; c < sizeC; ++c) {
            byte[] b = this.reader.openBytes(this.reader.getIndex(z, c, t), x, y, w, h);
            System.arraycopy(b, 0, buf, c * b.length, b.length);
        }
        return buf;
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }
}

