/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import loci.common.CompressedRandomAccess;
import loci.common.HandleException;

public class GZipHandle
extends CompressedRandomAccess {
    public GZipHandle(String file2) throws IOException {
        int skip;
        this.file = file2;
        if (!GZipHandle.isGZipFile(file2)) {
            throw new HandleException(file2 + " is not a gzip file.");
        }
        this.resetStream();
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        this.resetStream();
    }

    public static boolean isGZipFile(String file2) {
        return file2.toLowerCase().endsWith(".gz");
    }

    public void seek(long pos) throws IOException {
        long diff = this.fp - pos;
        this.fp = pos;
        if (diff >= 0L) {
            int n;
            int skipped = this.stream.skipBytes((int)diff);
            while ((long)skipped < diff && (n = this.stream.skipBytes((int)(diff - (long)skipped))) != 0) {
                skipped += n;
            }
        } else {
            int n;
            this.resetStream();
            int skipped = this.stream.skipBytes((int)this.fp);
            while ((long)skipped < this.fp && (n = this.stream.skipBytes((int)(this.fp - (long)skipped))) != 0) {
                skipped += n;
            }
        }
    }

    private void resetStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        this.stream = new DataInputStream(new GZIPInputStream(bis));
    }
}

