% FILE
%	si2d.m
%
% AUTHOR
%	rwy Cambridge Consultants (project leader J.A. Bangham, UEA)
%   updated all variable names to be more readable
%   made compatible with Matlab 2013a
%   32 bit
%   One day I'll upgrade to take advantage of 64 bit compilation
% 
% MODIFICATION HISTORY
%
%	1.1	02:jun:95	rwy	First version submitted to SCCS.
%	1.2	26:jun:95	rwy	Extended for open, close, M & N sieves.
%	1.3	27:jul:95	rwy	Allows bandpass outputs & granule fusing
% 	1.4	03:aug:95	rwy	Minor revision.
%	1.5	09:aug:95	rwy	Added granule output.
%	1.6	14:sep:95	rwy	Added edge map output.
%   2.0 01/01/2013  jab Updated to Matlab2013a and includes additional outputs
%                   more compatible with Matlab MSER
%	
% SCCS IDENTIFIER
%	@(#)sieve2d.m	1.6 9/14/95
%	@(#)SIV2d.m	2.0 01/01/2013
%       siv2d.c     01/10/2013
%
%
% [Y1 Y2 ... Ym] = siv2d(X, [M1 M2 ... Mn], 'F1F2 ... Fn', 
%						[O1 O2 ... On], type, N)
%
% Perform a 2-D connected-set datasieve based on area.
%
% X	:	input image
% Mk	:	maximum mesh for each filter
% Fk	:	filter type  (m, o, c, M or N)	[default: m]
% Ok	: 	output index for each filter    [default: 1 for last filter]
% type  :	output type  (l, b, e or f)	[default: l]
% N	:	connectivity (4 or 8)           [default: 4]
% Yj	:	output image from a filter 
%
% The input image is processed using one or more filters Fk, applied 
% sequentially, up to the associated maximum meshes Mk.  The available 
% filters are:
%
% m     :	median     (maxima & minima processed in arbitrary order)
% o     : 	opening    (only maxima processed)
% c     : 	closing    (only minima processed)
% M     : 	open-close (maxima then minima processed at each scale)
% N     : 	close-open (minima then maxima processed at each scale)
%
% For each filter, the result may optionally be output by specifying the
% index of the desired output argument as the input Ok (where Ok=1 represents 
% the first output argument).  If Ok=0 then no output is generated 
% for filter Fk.
%
% The available output types are:
%
% l	:	low-pass
% b	:	band-pass 
% f	:	band-pass with granule fusing
% e  	:	band-pass, returning edge map
% g	:	granule list
%
% where the band-pass output is the difference between the outputs of the
% current filter and the previous filter (or the input image) in the 
% sequence of filters.  The same output type must be used for each filter.
%
% The granule output list format is a vector containing the following data:
%
% 	[image_vdim image_hdim gran1_len gran1_val gran1_pos gran2_len ...]
%
% where gran?_pos is a list of the positions of the granule pels within
% the image (one scalar index per pel).
%
% Note that producing multiple low or band pass outputs in this way is much 
% more efficient than calling the sieve function several times with different
% meshes.  
%
% Memory requirements are about 18 bytes per image pel.
%
%
% EXAMPLES:
%
% Filter up to mesh 100 using a median sieve, and generate a low pass output:
%
% 	Y = siv2d(x, 100)
% or 	Y = siv2d(x, 100, 'm')
% or	Y = siv2d(x, 100, 'm', 1)
% or	Y = siv2d(x, 100, 'm', 1, 'l')
%
% Filter up to mesh 10 using a median sieve, then up to mesh 100 using an 
% opening operator, and output the band pass signal between meshes 11 and 100:
%
%	Y = siv2d(x, [10 100], 'mo', [0 1], 'b')
%
% Form a sequence of low pass outputs using closing operators:
%
%	[Y1 Y2 Y3 Y4] = siv2d(x, [8 16 32 64], 'cccc', [1 2 3 4])
%
% As above, with initial noise reduction using a median filter:
%
%	[Y1 Y2 Y3 Y4] = siv2d(x, [4 8 16 32 64], 'mcccc', [0 1 2 3 4])
%
% As above, but producing band pass outputs with granule fusing:
%
%	[Y1 Y2 Y3 Y4] = siv2d(x, [4 8 16 32 64], 'mcccc', [0 1 2 3 4], 'f')
%
% siv2d is a mex function
% function varargout=siv2d(varargin)
%     varargout=siv2d(varargin);
% end
