function [new_spring_length] = warp_springs(S, ungrowth_tensors, spring_edges)
% function [new_spring_length] = warp_springs(S, ungrowth_tensors)
%
% Inputs:
%   S - springs to be warped
%   scaling_factors - the difference in region information
%
%
% Dr. A. I. Hanna 2007
%
if nargin<2,
    error('Insufficient arguments');
end
pts = S.tri_info.pts;
% recall that spring edges has been constructed so that column 1 is point 1,
% column 2 is point 2 and column three is the region the spring belongs
% too.
%spring_edges = S.tri_info.spring_edge{grid_id};
num_springs = size(spring_edges,1);
new_spring_length = zeros(num_springs, 1);
for i=1:num_springs
    spring = spring_edges(i,:);
    v = pts(spring(1),:)' - pts(spring(2),:)';
    GT = ungrowth_tensors(:,:,spring(3));

    
    [smax, smin, theta] = gtlib_growthTensor2Params(GT);
    GT = gtlib_growthParams2Tensor(1/smax, 1/smin, theta);
    new_spring_length(i) = norm(GT(1:2, 1:2)*v);
end
return;

%num_ctrl_pts = S.region_info.num_ctrl_pts;
% Get the number of internal springs
%T=S.region_info.num_vert;
T = size(S.region_info.spring.vert,1);
% N - the adjacency matrix
N=S.region_info.spring.adj_mat;
% The current rested length matrix
L=S.region_info.spring.len_mat;
% The xy values of each centroid
xy=S.region_info.spring.vert;
%figure(1); clf; hold on;
%plot_grid(S.region_info, gca);
%axis image xy;
for i=1:T
    ci=xy(i,:);
    neighbours = find(N(i,:));
    for j=neighbours
        cj=xy(j,:);
%         if j>num_ctrl_pts
%             region_number = j - num_ctrl_pts;
%         else
%             region_number = j;
%         end
%         region_number = find_region(ci, cj, S.region_info.centroids);
        region_number = N(i,j);
        GT = ungrowth_tensors(:,:,region_number);
        [smax, smin, theta] = gtlib_growthTensor2Params(GT);
        GT = gtlib_growthParams2Tensor(1/smax, 1/smin, theta);

        v = cj(:) - ci(:);
        % the reason that we do this is so that we use the length as
        % calculated earlier. Remember the length of centroid-centroid
        % springs will not be the distance between the centroids.
         %len_v = norm(v);
         %v = v./len_v;
         %v = v*L(i,j);
        L(i,j) = norm(GT(1:2, 1:2)*v);
    end
end
S.region_info.spring.len_mat = L;
%%%
%
%%%
% function region_number = find_region(ci, cj, centroids)
% midpt = (ci+cj)/2;
% d = matdistance(midpt, centroids);
% [val, ind] = min(d);
% region_number = ind(1);
% return;