function shape_springs = warp_shape_springs(Edgs, shape_springs, scaling_factors)
pts = Edgs(:, end-1:end);
for i=1:length(shape_springs)
    spr = shape_springs(i);
    p1 = pts(spr.indx(1),:);
    p2 = pts(spr.indx(2),:);
    ang=atan2(p2(2)-p1(2),p2(1)-p1(1));
    spr.dist = calcWarpedSpringLength(spr.dist, scaling_factors.s_max(spr.region), scaling_factors.s_min(spr.region), scaling_factors.theta(spr.region), ang);
    shape_springs(i) = spr;
end

return;