function [Edg] = warp_edges(S, scaling_factors, Edg);
%  E added for agungrowstep212(to remove later) 04/12/00
%         uses principal direction of growth
%         Warp edges in Edg, using region difference in D and centroid of regions
%         in S. 
%          S   : springs warped
%          D   : output from diffregions
%		   Edg : edges info
%
%
%         (c) ag rolland 2000
%         Dr. A. I. Hanna (2005)
if nargin<3,
	error('Insufficient arguments');
end
T=size(S,1);
xy=S(:,2*T+(1:2));
N=Edg(:,1:T);
L=Edg(:,T+(1:T));
xyEdg=Edg(:,2*T+(1:2));
for l=1:size(Edg,1),
    ce=xyEdg(l,:);
    neighbours = find(N(l,:));
    for j=neighbours
        cj=xy(j,:);
        ang=atan2(cj(2)-ce(2),cj(1)-ce(1));
        L(l,j) = calcWarpedSpringLength(L(l,j), scaling_factors.s_max(j), scaling_factors.s_min(j), scaling_factors.theta(j), ang);
    end
end
Edg(:,T+(1:T)) = L;
