function Z=turn(X,A)
%Z=turn(X,A)  Turn Vector(s) X through angle A radians clockwise.
%             X should be a column of vectors.
%             ie [ x1 y1;
%                  x2 y2;
%                  x3 y3;
%                  :  :
%                  xn yn ]
%
%             Returns Z, and is of same dimensions as X.
%

Z=(X*[cos(A) -sin(A); sin(A) cos(A)]);
