function U=trans2nd(T,X,Y)
%U=trans2nd(T,X) Perform 2nd order transformation T on column of vectors X
%         X = [x1 y1; x2 y2; ...; xn yn];
%         T = [a00 b00; a10 b10; a01 b01; a11 b11; a20 b20; a02 b02];
% 
%U=trans2nd(T,X,Y)
%        Perform 2nd order transformation T on column of vectors (X,Y)
%
%        Returns column of vectors U
%         U = [u1 v1; u2 v2; ...; un vn];
%
%        See also: get_trans2nd.m
%
%        (c) Stephen Impey, 1997
%

if nargin<2,
   error('Insufficent arguments');
end

if nargin<3,
   Y=X(:,2);
   X=X(:,1);
end

U=[ones(length(X),1) X(:) Y(:) Y(:).*X(:) X(:).*X(:) Y(:).*Y(:)]*T;
