function show_library_functions
% function show_library_functions
% 
% Displays the files in the LibarayFunctions directory for SAToolbox
%
% Dr. A. I. Hanna (2007)
sat_root = which('SectorAnalysisToolbox.m');
if isempty(sat_root)
    fprintf('Could not find SectorAnalysisToolbox on this machine\n');
    return;
end
[pathname, filename] = fileparts(fileparts(sat_root));
lib_funcs = dir([pathname, filesep, 'LibraryFunctions', filesep, '*.m']);
lib_funcs = {lib_funcs.name};
for i=1:length(lib_funcs)
    fprintf('%s\n', lib_funcs{i});
end