% show_average_ellipses_all_stages(mean_shape_dir, stage_dir)
%
% Dr. A. I. Hanna (2005);
function show_grid_regions(mean_shape_dir, grid_path, grid_file)
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
stagedDir = 'Staged';
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];

d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   [stagedDir, filesep,  str{s}];
end
files = dir(stagedDir);
files = {files.name};
ind = [];
for f = 1:length(files)
    file = files{f};
    if (file(1) == '.') || strcmp(file, 'Data')
        ind = [ind; f];
    end
end
files(ind) = [];
d = dir(gridDir);
str = {d.name};
if nargin<2
    [s,v] = listdlg('PromptString','Select a grid:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Sorry not a valid SectorAnalysis project directory\n');
        return;
    end
    grid_file = str{s};
    grid_path = gridDir;
end

grid_info = load([grid_path, filesep, grid_file]);

M = 1;
N = 1;
figure;
c = 1;
scale = 20;
ellipcol = [0 0 0];

for i=1:length(grid_info.stage_grids)
    if c>N*M
        c = 1;
        figure;
    end
    curr_grid = grid_info.stage_grids{i};
    centroids = calcStageGridCentroids(curr_grid);
    subaxis(M, N, c,'Spacing',.01, 'MR', .1); c = c+1;
    set(gca, 'Clipping', 'on');
    plot_grid(curr_grid);
    hold(gca, 'on');
    axis image ij;
    for i=1:size(centroids,1)
    text(centroids(i,1),centroids(i,2), sprintf('Region %d',i)); %,'FontSize', 8, 'Clipping', 'on')); 
    end
   % info = curr_grid.average_sectors.prev;
    title(curr_grid.stage_info.prev, 'Interpreter', 'none');
    grid on;
end
return


