%
% show_stage_sector_info(mean_shape_dir, stage_dir)
%
% Dr. A. I. Hanna (2005);
function show_average_number_of_sectors(mean_shape_dir, stage_dir)
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
% Set up some directory constants
stagedDir = ['Staged'];
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];
d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   [stagedDir, filesep,  str{s}];
end
files = dir(stagedDir);
files = {files.name};
files = cleanup_stage_list(files);

av_num_stage = [];
waitbar_h = waitbar(0, 'Please wait...');
for i=1:length(files)
    waitbar(i/length(files), waitbar_h);
    imfiles = FindFilenames('mat', [stagedDir, filesep, files{i}]);
    av_num = 0;
    num_files = 0;
    for ii=1:length(imfiles)
        [path, filename, ext, vers] = fileparts(imfiles{ii});
       if strcmp(filename, 'sector_info')
            file = load([imfiles{ii}]);
            av_num = av_num + length(file.sector_info);
            num_files = num_files + 1;
       end
    end
    av_num_stage(i) = av_num/num_files;
end
close(waitbar_h);
figure;
set(gcf, 'Pos', [196         519        1466         422]);
set(gcf, 'Name', 'Average Number of Sectors Per Stage');

x = 1:length(files);
plot(x, av_num_stage, '-o', 'Color', 'b', 'MarkerEdgeColor', 'r', 'MarkerFaceColor', 'y');
axis tight xy;
grid on;
set(gca, 'XTick', x, 'XTickLabel', files)
xlabel('Stage');
ylabel('Average number of sectors');
grid on;
title('Average Number of Sectors Per Stage');
