
function average_info_est = recalc_average_info(av_info, ang, stage_idx)
average_info_est = {};
for i=1:length(av_info)
    av_region_tensors = av_info{i};
    av_region_tensors = av_region_tensors.average_stage_sector_info;
    for j=1:length(ang)
        theta = ang{j};
        R = [cos(theta) -sin(theta) 0; sin(theta) cos(theta) 0; 0 0 1];
        av_region_tensors(:,:,j) = R*av_region_tensors(:,:, j);
    end 
    average_info_est = cat(1, average_info_est, av_region_tensors);
end
return

function [info] = recalc_average_info(info, T)

for l=1:length(info)
    I = info{l};
    for r = 1:size(I,3)
        [maj, min, theta] = gtlib_growthTensor2Params(I(:,:,r));
        

        v = [1; 0];
        R = maj*[cos(theta) -sin(theta); sin(theta) cos(theta)];
        v1 = R*v;
        theta = mod(theta + pi/2, pi);
        R = min*[cos(theta) -sin(theta); sin(theta) cos(theta)];
        v2 = R*v;
        % To inv or not to inv, that is the question
        invT = inv(T{r});
        %invT = T{r};
        wv1 = invT*v1;
        wv2 = invT*v2;
        maj = norm(wv1);
        min = norm(wv2);
        theta = atan2(wv1(2), wv1(1));
        I(:,:,r) = gtlib_growthParams2Tensor(maj, min, theta);
    end
    info{l} = I;
% 
%         figure(1); clf; hold on;
%         plot([0 v1(1)],[0 v1(2)], 'r');
%         plot([0 v2(1)],[0 v2(2)], 'b');
%         plot([0 wv1(1)],[0 wv1(2)], 'r:');
%         plot([0 wv2(1)],[0 wv2(2)], 'b:');
end
return;

for l=1:length(info)
    I = info{l};
    for r = 1:size(I,1)
        theta = mod(I(r, 6), pi);
        v = [1; 0];
        R = I(r, 4)*[cos(theta) -sin(theta); sin(theta) cos(theta)];
        v1 = R*v;
        theta = mod(theta + pi/2, pi);
        R = I(r, 5)*[cos(theta) -sin(theta); sin(theta) cos(theta)];
        v2 = R*v;
        % To inv or not to inv, that is the question
        invT = inv(T{r});
        %invT = T{r};
        wv1 = invT*v1;
        wv2 = invT*v2;
        I(r, 4) = norm(wv1);
        I(r, 5) = norm(wv2);
        I(r, 6) = atan2(wv1(2), wv1(1));
    end
    info{l} = I;
% 
%         figure(1); clf; hold on;
%         plot([0 v1(1)],[0 v1(2)], 'r');
%         plot([0 v2(1)],[0 v2(2)], 'b');
%         plot([0 wv1(1)],[0 wv1(2)], 'r:');
%         plot([0 wv2(1)],[0 wv2(2)], 'b:');
end
return;