function [R] = range2layers(R1, reg_x, reg_y)
R=logical(zeros(size(R1,1), size(R1,2), reg_x*reg_y+1));
R(:,:,1) = R1;
layer=1;
xr=range(find(any(R1)));
yr=range(find(any(R1')));
dx=ceil(diff(xr)/reg_x);
dy=ceil(diff(yr)/reg_y);
for i=1:reg_x
    for j=1:reg_y
        r=logical(zeros([size(R1,1) size(R1,2)]));
        r(yr(1)+dy*(j-1)+(1:dy),xr(1)+dx*(i-1)+(1:dx))=logical(ones(dy,dx));
        r=r&R1;
        if any(r(:))
            layer=layer+1;
            R(:,:,layer) = r;
            R1=xor(r,R1);
        end
    end
end
return;