function [ellipse_axis_handle] = plot_ellipse_axis(axis_handle, ellipse_info, color)
% function [ellipse_axis_handle] = plot_ellipse_axis(axis_handle, ellipse_info, color)
%
% This function takes an axis handle and a stucture r that contains
% information about an ellipse.
%
% r has structure as follows:
%
% r.Orientation
% r.MajorAxisLength
% r.MinorAxisLength
% r.Centroid
%
% Used in: plot_ellipse
%
% Dr. A. I. Hanna (2006)
    
ellipse_axis_handle = [];
if nargin <2
    return;
end
if nargin <3
    color = [0 0 1];
end
class=[0 16; 16 32; 32 64; 64 128; 128 256; 256 512; 512 1024; 1024 2048; 2048 5096; 5096 10192; ...
    10192 20384; 20384 40768; 40768 81536; 81536 300000];
map = jet(size(class,1));
map = flipud(map);
hold(axis_handle, 'on');
for i=1:length(ellipse_info)
    k = ellipse_info(i);
    if ~isfield(k, 'Area')
        a =1;
    else
        a = k.Area;
    end
    found_class = find((a>class(:,1))+ (a<=class(:,2))==2);
    if ~isempty(found_class)
        ph = gtlib_plotGrowthTensorCross('growth_tensor', k.growthTensor, 'offset', k.Centroid,  'colour', map(found_class,:), 'parent', axis_handle);
    end
end
return