function objplot(filename)
if nargin<1
    [filename, pathname] = uigetfile('*.obj', 'Pick an OBJ-file');
    if isequal(filename,0) | isequal(pathname,0)
        disp('User pressed cancel')
        return;
    else
        filename = [pathname, filesep, filename];
        disp(['User selected ', fullfile(pathname, filename)])
    end
end
[tri, v] = objread(filename);
figure;
triplot(tri, v(:,1), v(:,2));
axis image ij;
grid on;