function [] = makeobj()
[filename, pathname] = uigetfile('*.mat', 'Pick some ungrowth data', [pwd, filesep, 'Staged\Data\UngrowthData\']);
if isequal(filename,0) | isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(pathname, filename)]);
    l = load(fullfile(pathname, filename));
    G = l.ungrown_grid;
end
pathname = uigetdir([pwd, filesep], 'Pick a Directory');

if pathname == 0
    return;
end
figure(1); clf; hold on;
for stage_indx=1:length(G)-1
%for stage_indx=1:3

    g = G(stage_indx);
    S = g.S;
    E = g.Edgs;
    ep = double(g.edge_petal);
    T=size(S,1);
    x=E(:,2*T+1);
    y=E(:,2*T+2);
    xc=S(:,2*T+1);
    yc=S(:,2*T+2);
    R = buildregions(g);
%     xc = [];
%     yc = [];
%     for i=1:max(R(:))
%         L = bwlabel(R==i);
%         stats = regionprops(L);
%         c = stats(1).Centroid;
%         xc = [xc; c(2)];
%         yc = [yc; c(1)];
%         
%     end
%     xc = round(xc);
%     yc = round(yc);
%     
    
%     for i=1:length(g.order)
%         o = g.order{i};
%         [tempx, tempy] = interp_vertex_points(x(o), y(o));
%         [tempx, tempy] = interp_vertex_points(tempx, tempy);
%         x = [x; tempx];
%         y = [y; tempy];
%     end
     d = [x, y; yc, xc];

    trans_c = min(d);
    xct = xc - trans_c(2);
    yct = yc - trans_c(1);
    d = d - ones(size(d,1),1)*trans_c;
    ep(:,1:2) = ep(:,1:2) - ones(size(ep(:,1:2),1),1)*trans_c;
    g.Edgs(:,end-1:end) = g.Edgs(:,end-1:end) - ones(size(g.Edgs(:,end-1:end),1),1)*trans_c;
    %tritemp = delaunay(d(:,1), d(:,2));
    %tritemp = removeOutsideFaces(tritemp, d, double(ep));
    
    
    if stage_indx == 1
        tritemp = delaunay(d(:,1), d(:,2));
        tritemp = removeOutsideFaces(tritemp, d, double(ep));
        %bad_tri = find_bad_triangles(tri, d, .3);
        %tri(bad_tri, :) = [];
    end
    tri= tritemp;
%     [tritemp2, d] = interp_tri(tritemp, d, 1);
%     if stage_indx == 1
%         tritemp2 = delaunay(d(:,1), d(:,2));
%         tri = removeOutsideFaces(tritemp2, d, double(ep));
%         %bad_tri = find_bad_triangles(tri, d, .3);
%         %tri(bad_tri, :) = [];
%     end

    R = buildregions(g);

    new_indx = length(G) - stage_indx;
    smin = l.growth_parameters.scaling_factors(new_indx).s_min;
    smax = l.growth_parameters.scaling_factors(new_indx).s_max;
    theta = l.growth_parameters.growth_params{new_indx}(:,3);

        smin = l.growth_parameters.scaling_factors(stage_indx).s_min;
    smax = l.growth_parameters.scaling_factors(stage_indx).s_max;
    theta = l.growth_parameters.growth_params{stage_indx}(:,3);
    remove_ind = [];
    for t = 1:size(tri,1)
        tri_center = sum(d(tri(t,:), :))/3;
        plot(tri_center(1), tri_center(2), 'wo');
        region_number(t) = R(round(tri_center(2)), round(tri_center(1)));
        if region_number(t) == 0
            if stage_indx == 1
                remove_ind(end+1) = t;
                tri_info(t, :) = [0,0,0];
            else
                dist = sqrt(sum(([yct, xct] - ones(length(yct),1)*tri_center).^2,2));
                [val, pos] = min(dist);
                region_number(t) = R(round(xct(pos(1))), round(xct(pos(1))));
                tri_info(t, :) = [smax(region_number(t)), smin(region_number(t)), theta(region_number(t))];

            end
        else
            tri_info(t, :) = [smax(region_number(t)), smin(region_number(t)), theta(region_number(t))];
        end
    end
    tri(remove_ind,:) = [];
    tri_info(remove_ind,:) = [];
    imagesc(R);
    triplot(tri, d(:,1), d(:,2), 'w', 'LineWidth', 1);
    drawnow
    pause(.2);
    filename = [pathname, filesep, 'stage_', num2str(stage_indx), '.obj'];
    fprintf('Saving as %s.\n', filename);
    if ~isempty(filename)
        fid = fopen(filename,'w');
        for i=1:size(d,1)
            fprintf(fid, 'v %5.5f %5.5f %5.5f\n', d(i,1), d(i,2), 0);
        end
        for i=1:size(tri,1)
            fprintf(fid, 'f %d %d %d\n', tri(i,1), tri(i,2), tri(i,3));
        end
        fclose(fid);
    end

    size(d)
    size(tri)
    %[path, filename, ext, vers]= fileparts(filename);
    %filename = [filename, '.tri_info'];
    filename = [pathname, filesep, 'stage_', num2str(stage_indx), '.tri_info'];
    if ~isempty(filename)
        fid = fopen(filename,'w');
        for i=1:size(tri_info, 1)
            fprintf(fid, '%d %5.5f %5.5f %5.5f\n', i, tri_info(i,1), tri_info(i,2), tri_info(i,3));
        end
        fclose(fid);
    end
end
function region_num = find_region(R, t, d)
region_num = sum(d(t, :))/3;
return

function R = buildregions(g)
E = g.Edgs(:,end-1:end);
R = zeros(ceil(max(E(:,2))), ceil(max(E(:,1))));
for i=1:length(g.order)
    p=g.Edgs(g.order{i}, end-1:end);
    r = roipoly(R, p(:,1), p(:,2));
    R = R + r*i;
    figure(1); cla;
    imagesc(r);
    axis image ij;
end
return;

