function [stage_info] = load_stage_sector_info(stage, arealim)
%function [stage_info] = load_stage_sector_info(stage, arealim)
%
% Dr. A. I. Hanna (2006)
stage_info = [];
stage_files = findfiles('warped_sector_info.mat', stage);
number_of_files_in_stage = length(stage_files);

for ii = 1:number_of_files_in_stage
    file = stage_files{ii};
    [image_directory, stage_directory] = get_parent_dir(file);
    sector_info = load(file);
    sector_info = sector_info.warped_sector_info;
    stage_info = cat(2, stage_info, sector_info);
end
 area = [stage_info.ellipArea];
stage_info(area<arealim) = [];
return