function V=img_centroid(X);
%V=img_centroid(X);
%         Return centre of mass V=[x y] of non-zeros in image matrix X.
%         If image is all zeros returns V as image centre.
%
%         Ensure region in image is flat (equal value).
%
%         (c) Stephen Impey, 1996
%

w=size(X,2);
h=size(X,1);

if w==1 | h==1,
	if w==1,
		X=[X , zeros(h,1)];
		w=w+1;
	end

	if h==1,
		X=[X ; zeros(1,w)];
		h=h+1;
	end
end

V=[0 0];

s=sum(X);
t=s*(1:w)';

V(1)=t/sum(s);

s=sum(X');
t=s*(1:h)';

V(2)=t/sum(s);

