function [doubling_time, anisotropy, ang] = growthParameters2GrowthRateAnisotropy(gp, T)
% function [doubling_time, anisotropy] = growthParameters2GrowthRateAnisotropy(gp, T)
%
% A function thats takes a structure gp with fields, s_max, s_min and
% theta. Each of the fields is a Nx1 vector where N denotes the number of
% regions for that organ. So for an organ with 12 regions we would have 
% 
% gp = 
%    s_max: [12x1 double]
%    s_min: [12x1 double]
%    theta: [12x1 double]
%
% The other input is T, this denotes the number of hours it takes for the
% organ to double in size (default T = 20).
%
% Returns the doubling times and the anisotropy rates for each region.
%
% See also: getDoublingTimeColours, getAnisotropyColours
%
% Dr. A. I. Hanna (2007)
if nargin<2
    T = 20;
end
num_regions = size(gp,3);
anisotropy = zeros(num_regions,1);
doubling_time = zeros(num_regions,1);
ang = zeros(num_regions,1);

for i=1:num_regions
    growth_tensor = gp(:,:,i);
    [SMAX, SMIN, theta] = gtlib_growthTensor2Params(growth_tensor);
    a = SMAX;
    b = SMIN;
    ang(i) = theta;
    if (a==0) || (b==0)
        anisotropy(i) = 0;
        doubling_time(i) = 0;
    else
        area_scaling =  SMAX.*SMIN;
        growth_ratio = SMAX./SMIN;
        anis = growth_ratio.^(log(2)./log(area_scaling));
        anisotropy(i) = round(anis*100)/100;
        doubling_time(i)=round(T*log(2)./log(area_scaling));
    end
end
return;