function g = getproftc(img,pStart,pEnd,nPixels)
%GETPROFTC Get normalised gray level difference profile from START -> END
%          G = GETPROFTC(IMG,START,END,NPIXELS)
%
%@(#)getproftc.m	1.2 30 Aug 1996
%Iain Matthews, UEA, Norwich

% Check args
if nargin<4 error('Invalid args'); end

% Calculate coords of path - profile goes OUT of model
theta = atan2(pEnd(2)-pStart(2),pEnd(1)-pStart(1));
hstep = 1.0;

xstep = hstep * cos(theta);
ystep = hstep * sin(theta);

% NB n+1 pixels for a length of n pixels (centre of pixel is its location)
% Then add 2 for space to calculate derivative - one on either end
xx = ones(nPixels+3,1) * xstep;
xx = cumsum(xx);

yy = ones(nPixels+3,1) * ystep;
yy = cumsum(yy);

x = ones(nPixels+3,1) * pStart(1) - 2*xstep;
y = ones(nPixels+3,1) * pStart(2) - 2*ystep;

x = x + xx;
y = y + yy;

% Nearest to floating point coordinate
xr = round(x);
yr = round(y);

% Check for -ve indicies, just set to 1 (derv = 0)
xridx = find(xr < 1);
yridx = find(yr < 1);
if any(xridx)
	xr(xridx) = ones(length(xridx),1);
end
if any(yridx)
	yr(yridx) = ones(length(yridx),1);
end

% Check for too large indicies, set to max
xridx = find(xr > size(img,2));
yridx = find(yr > size(img,1));
if any(xridx)
	xr(xridx) = ones(length(xridx),1) * size(img,2);
end
if any(yridx)
	yr(yridx) = ones(length(yridx),1) * size(img,1);
end

% Get profile
prof = diag(img(yr,xr));

% Derivative profile
%g = prof(3:nPixels+3) - prof(1:nPixels+1);

% Normalise
%g = g/sum(abs(g));

g=prof;
