function T=get_trans2nd(U,X)
% T=get_trans2nd(U,X)
%         Given two nx2 (n>=6) matrices, U and X defining two polygons
%         this function returns vector T the a 2nd order polynomial
%         transformation coefficients.
%
%         See also: trans2nd, warp2
%
%         See: Digital Image Warping (George Wolberg) page 64.
%
%         (c) Stephen Impey, March 1996
%

n=size(U,1);

u=U(:,1);
v=U(:,2);
x=X(:,1);
y=X(:,2);

Z=[ones(n,1) u v u.*v u.*u v.*v];

T=[Z\x Z\y];
