%
% [parent_dir_name, parent_dir_path] = get_parent_dir(name)
%
% This function takes a name and performs the fileparts operation twice, it
% returns (only) the name of the parent directory, 
%
% example: 
%
%    >> get_parent_dir('C:\Documents and Settings\aih\My Documents\post_doc\SectorAnalysisToolbox\SAT_Matlab_files_AIH')
%    ans = 
%    SectorAnalysisToolbox
% 
% Dr. A. I. Hanna (2005)
function [parent_dir_name, parent_dir_path] = get_parent_dir(name)
[path, name, ext, versn] = fileparts(name);
[parent_dir_path, parent_dir_name, ext, versn] = fileparts(path);