function C = getDoublingTimeColours(doubling_time, mapstr)
% function C = getDoublingTimeColours(doubling_time)
%
% A function that takes an Nx1 vector containing the values of
% doubling time for a particular region. It returns the colours 
% for those regions as defined in "Growth dynamics underlying petal 
% shape and asymmetry", A. G. Rolland Lagan et. al., Letters to Nature, 
% vol 422, 13th March, 2003.
%
% See also: getAnisotropyColours, growthParameters2GrowthRateAnisotropy
%
% Dr. A. I. Hanna (2007)
%matri=hsv(60);
matri = feval(mapstr, 60);
C = zeros(length(doubling_time), 3);
for i=1:length(doubling_time)
    dbtime = doubling_time(i);
    if (dbtime<=11)
        colbr=[1 0 0];
    elseif (dbtime>=48)
        colbr=[0.7 0.7 1];
    else
        colbr=(matri((floor(((dbtime-11)/(48-11))*40 +1)),:));
    end;
    C(i,:) = colbr;
end
return;