function C = getAnisotropyColours(anisotropy, mapstr)
% function C = getAnisotropyColours(anisotropy)
%
% A function that takes an Nx1 vector containing the values of anisotropy
% for a particular region. It returns the colours for those regions as
% defined in "Growth dynamics underlying petal shape and asymmetry", A. G.
% Rolland Lagan et. al., Letters to Nature, vol 422, 13th March, 2003.
%
% See also: getDoublingTimeColours, growthParameters2GrowthRateAnisotropy
%
% Dr. A. I. Hanna (2007)

col_lim = [1.03 1.3];
matri = feval(mapstr, 60);
matri=matri(1:40,:);
matri=flipud(matri);
C = zeros(length(anisotropy), 3);
for a = 1:length(anisotropy)
    ran = anisotropy(a);
    if (ran<=col_lim(1))
        colbr=[0.7 0.7 1];
    elseif (ran>=col_lim(2))
        colbr=[1 0 0];
    else
        colbr=(matri((floor(((ran-col_lim(1))/(col_lim(2)-col_lim(1)))*40 +1)),:)); %2 for step1, go back to 1.8
    end
    C(a,:) = colbr;
end
return;