function [data] = fitGrowthTensor(PC)
% Dr. A. I. Hanna (2007).
if nargin<1
    data = [];
    return;
end
if size(PC,1)==1
    data.growthTensor = eye(3,3);
    data.Centroid(1) = PC(1);
    data.Centroid(2) = PC(2);
    data.ellipArea = 1;
    data.Area = 1;
    return;
end
mean_PC = mean(PC);
if length(mean_PC)==1
    mean_PC = [mean_PC, mean_PC];
end
PC = PC - ones(size(PC,1),1)*mean(PC);
% find the eigenvalues of this set of data
[V, D] = eig(PC'*PC);
% we want the vector of most variance first, i.e. the principle direction
% of growth.
[Y, I] = sort(diag(D), 'descend');
V = V(:, I);
% Now align the data with i, j, k, so we can calculate the range of the sector along
% the major and minor axes.
ProjC = (V'*PC')';
smax = max(abs(ProjC));
if V(1,1)==0
    theta = pi/2;
else
    theta = atan(V(2, 1)/V(1,1));
end

G = gtlib_growthParams2Tensor(smax(1), smax(2), theta);
%G = gtlib_growthParams2Tensor(smax(1), smax(2), acos(V(1,1)));
data.growthTensor = G;
data.Centroid(1) = mean_PC(1);
data.Centroid(2) = mean_PC(2);
data.ellipArea = pi*smax(1)*smax(2);
data.Area = polyarea(PC(:,1), PC(:,2));
return;
