function [ind] = find_bad_triangles(tri, vertices, thr)
ind = [];
for i=1:length(tri)
    [v1, v2, v3] = tri2vec(tri(i,:), vertices);
    v1 = [v1(:); 0];
    v2 = [v2(:); 0];
    para_area = norm(cross(v1, v2));
    circ = 2*(norm(v1) + norm(v2));
    if (para_area/circ)<thr
        ind = [ind; i];
    end
end 