function [marker_handle, line_handle, text_handle] = display_shape_springs(S, Edgs, shape_springs, image_axis)
% function [marker_handle, line_handle, text_handle] = display_springs(S,image_axis)
if nargin<3,
    error('Insufficient arguments');
end
if nargin<4
    image_axis = gca;
end

T=size(S,1);
pts = Edgs(:, 2*T+1:end);
hold(image_axis, 'on');
for i=1:length(shape_springs)
    spr = shape_springs(i);
    plot(image_axis, [pts(spr.indx(1),1) pts(spr.indx(2),1)],[pts(spr.indx(1),2) pts(spr.indx(2),2)], 'b');
end
hold(image_axis, 'off');
