% function [organ_shape_handle] = display_organ(xy_regions, image_axis)
%
% Dr. A. I. Hanna (2005)
function [organ_shape_handle] = display_organ(xy_regions, image_axis, color, sz)
if nargin<1
	error('Insufficient arguments');
end
if nargin<2
    image_axis = gca;
end
if nargin<3
    color = [0 0 1];
end
if nargin<4
    sz = 5;
end
organ_shape_handle = [];
hold(image_axis, 'on');
for i=1:length(xy_regions)
    r = xy_regions{i};
    if ~isempty(r)
        r = [r; r(1,:)];
        organ_shape_handle(end+1) = plot(image_axis, r(:,1), r(:,2), 's-', 'MarkerSize', sz, 'LineWidth', 1, 'Color', color, 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'y');
    end
end
axis(image_axis, 'image', 'ij');
hold(image_axis, 'off');
return;