function [marker_handle, line_handle, text_handle] = display_growth_factors(S, scaling_factors, image_axis)
% function [marker_handle, line_handle, text_handle] = display_springs(S,image_axis)
if nargin<1,
    error('Insufficient arguments');
end
line_handle = [];
text_handle = [];
marker_handle = [];
T=size(S,1);
n=1:T;
p=1;
cpt=0;
xnod=[];
ynod=[];
N=S(:,1:T);
L=S(:,T+1:2*T);
x=S(:,2*T+1);
y=S(:,2*T+2);
hold(image_axis, 'on');

for i=n,
    scale = 3;
    smax = scaling_factors.s_max(i)*scale;
    smin = scaling_factors.s_min(i)*scale;
    theta = scaling_factors.theta(i);

    v = smax*[cos(theta); sin(theta)];
    plot(image_axis, [x(i) x(i) + v(1)],[y(i) y(i) + v(2)], '-', 'Color', 'r', 'LineWidth', 3);
    v = smin*[cos(theta+pi/2); sin(theta+pi/2)];
    plot(image_axis, [x(i) x(i) + v(1)],[y(i) y(i) + v(2)], '-', 'Color', 'b', 'LineWidth', 3);
end
hold(image_axis, 'off');
