%
% [files] = cleanup_stage_list(files)
% 
% This function takes in a cell array of filenames, from this list it
% removes the filename '.', '..', and 'Data' as these are reserved names in
% the 'Staged' Directory of a SectorAnalysisToolbox Project.
%
% Dr. A. I. Hanna (2005)
function [files] = cleanup_stage_list(files)
ind = [];
for f = 1:length(files)
    file = files{f};
    if (file(1) == '.') | strcmp(file, 'Data')
        ind = [ind; f];
    end
end
files(ind) = [];