function [sf] = calculate_growth_factors(sf)
t = 14;
for i=1:length(sf)
    s = sf(i);
    smax = 1./s.s_max;
    smin = 1./s.s_min;
    H = (1./smax).*(1./smin);
    G = t.*((log(2))./(log(H)));
    A = ((1./smax)./(1./smin)).^(G./t);
    sf(i).G = G;
    sf(i).A = A;
end

log2(s.s_max)/t - log2(sqrt(2.*A))./G

log2(s.s_min)/t - log2(sqrt(2.*A)./A)./G
return;

