function [region_info, areas] = calc_stage_sector_info_for_trimesh(stage, T, tri_pts,regs, area_thr)
%function [region_info, areas] = calc_stage_sector_info_for_trimesh(stage, T, regs, area_thr)
%
% A function to get the sector info for a particular stage in a particular
% region specified by R.
%
% Input Params:
%   stage - the path to the stage directory to work on
%   R - the MxNxR matrix where MxR is the size of the image and R is the
%       number of regions + 1
%   centroids - the Qx2 matrix of centroids, NOTE: centroids is of the form [y, x]
%
% Dr. A. I. Hanna (2006)
region_info = [];
if nargin < 3
    return;
end
stage_files = findfiles('warped_sector_info.mat', stage);
number_of_files_in_stage = length(stage_files);
region_info = cell(number_of_files_in_stage, 1);
areas = cell(length(stage_files),1);
num_regions = length(regs);
for ii = 1:number_of_files_in_stage
    file = stage_files{ii};
    [image_directory, stage_directory] = get_parent_dir(file);
    sector_info = load(file);
    sector_info = sector_info.warped_sector_info;
    areas{ii} = [sector_info.ellipArea];
    RegionInfo = cell(1, num_regions);
    for s=1:length(sector_info)
        info = sector_info(s);
        if info.ellipArea>area_thr
            tind = tsearch(tri_pts(:,1), tri_pts(:,2), T, info.Centroid(1), info.Centroid(2));
            if ~isnan(tind)
                region_num = findRegionContainingTri(regs, tind);
                if region_num ~=-1
                    RegionInfo{region_num} = cat(3, RegionInfo{region_num}, info.growthTensor);
                else
                    fprintf('calc_stage_sector_info: could not determine region for sector\n');
                end
            end
        else
            fprintf('area of ellipse is below threshold, %2.2f\n', area_thr);
        end
    end
    region_info{ii}.RegionInfo = RegionInfo;
    region_info{ii}.image_directory = image_directory;
    region_info{ii}.stage_directory = stage_directory;
end
areas = [areas{:}];
return