function [average_sector_info, empty_region_ind, region_density] = calc_average_stage_sector_info(info)
% function [average_sector_info] = calc_average_stage_sector_info(info)
%
% This function takes in a cell structure (info) where each element of the
% cell array corresponds to a region in the organ being analysed.
% The output parameter, average_sector_info, is a stucture whose length is
% the same as the number of regions on the organ being analysed. Each
% element of this structure contains the following
%
%
% Dr. A. I. Hanna (2007)

N = length(info{1}.RegionInfo);
average_sector_info = zeros(3,3,N);
empty_region_ind = [];
region_density = [];
for j=1:N
    M = [];
    % for each region, go through every file for this stage and build a
    % matrix of growth tensors
    for ii=1:length(info)
        R = info{ii}.RegionInfo{j};
        if ~isempty(R)
            M = cat(3, M, R);
        end
    end
    if isempty(M)
        M = eye(3,3);
        empty_region_ind = cat(1,empty_region_ind, j);
        region_density(j) = 0;
    else
        region_density(j) = size(M,3);
    end
    average_sector_info(:,:,j) = mean(M, 3);
end
mu = mean(average_sector_info,3);
for i=empty_region_ind'
    average_sector_info(:,:,i) = mu;
end
return;