function binmerge = bwmergeregions(I)
% function binmerge = bwmergeregions(I)
%
% This is a script that takes a binary image and then merges the seperate
% regions using a convex hull.
%
% Dr. A. I. Hanna (2006).
if (isempty(I))
	error('Invalid input image') ;
end
[Y, X] = find(I==1);
K = convhull(X,Y,{'Qt','Pp'});
X = X(K);
Y = Y(K);
R = order_xy_pts([X, Y]);
binmerge = roipoly(I, R(:,1), R(:,2));
return;