function Z=av_angle(A)
%Z=av_angle(A)
%        Find an approximation to average angle, problem with being circular.
%         A   : vector of angles in radians -pi/2<=theta<=pi/2
%
%        Method: Returns Z where it minimises
%                              sum((rem(A+Z,180)-90).^2)    {0<=Z<180}
%
%        (c) Stephen Impey, 1996-8
%
A=A(:);
ind = find(A<0);
A(ind) = A(ind) + pi;
A = A*(180/pi);
%[t Z]=min(sum((rem(A*ones(1,180) + ones(length(A),1)*(0:179),180)).^2));

[t Z]=min(sum((rem(A*ones(1,180) + ones(length(A),1)*(0:179),180)-90).^2));
Z=rem(271-Z,180);
Z = Z*(pi/180);
