function [control_ind, control_pts] = adjust_corners(R, control_ind, control_pts);
[y, x] = find(bwperim(R));
temp_pts = round(control_pts);
[in, on] = inpolygon(temp_pts(:,1), temp_pts(:,2), x, y);
ind = find(in == 0);
for i=1:length(ind)
   p = control_pts(ind(i),:);
   d = sqrt(sum(([x, y] - ones(length(x),1)*p).^2,2));
   [val, pos] = min(d);
   control_pts(ind(i), :) = [x(pos), y(pos)];
end
return;
