function [sf] = growthTensor2growthFactor(gt, t)
% function [gf] = growthTensor2growthFactor(gt, t)
%
% Takes a cell array of growth data and a doubling time t, and returns a
% growth rate and an anisotropy.
%
% Dr. A. I. Hanna (2007)
t = 14;
for i=1:length(sf)
    s = sf(i);
    smax = 1./s.s_max;
    smin = 1./s.s_min;
    H = (1./smax).*(1./smin);
    G = t.*((log(2))./(log(H)));
    A = ((1./smax)./(1./smin)).^(G./t);
    sf(i).G = G;
    sf(i).A = A;
end
return;

