function [UngrowthData, growth_params] = ungrow_assumption_two(R, growth_params, extern_iter, extern_spr_const, recalc_flag, animate, axis_handle, error_axis_handle)
% function [UngrowthData, growth_params] = ungrow_assumption_two(R, growth_params, extern_iter, extern_spr_const, recalc_flag, animate, axis_handle, error_axis_handle)
%
%
% Dr. A. I. Hanna (2007)
if nargin<2
    axis_handle = gca;
end
S = R.region_info.Springs.S;
Edgs = R.region_info.Springs.Edgs;
edge_petal = R.region_info.edge_petal;
control_pts = R.region_info.control_pts;
shape = R.region_info.shape;
REGS = R.region_info.REGS;
Rb = R.region_info.R;
N = growth_params.N;
if isfield(R.region_info.Springs, 'shape_springs')
    shape_springs = R.region_info.Springs.shape_springs;
else
    shape_springs = [];
end
num_growth_stages = length(growth_params.growth_params);
UngrowthData = cell(num_growth_stages+1, 1);
for i=1:num_growth_stages
    UngrowthData{i}.S = S;
    UngrowthData{i}.Edgs = Edgs;
    UngrowthData{i}.order = R.region_info.order;
    UngrowthData{i}.edge_petal = edge_petal;
    UngrowthData{i}.shape = shape;
    UngrowthData{i}.control_pts = control_pts;
    UngrowthData{i}.REGS = REGS;
    
    SF = growth_params.scaling_factors{i};

    S = warp_springs(S, SF);
    animate_edge = animate;
    scale_plot = 1;

    [Edgs] = warp_edges(S, SF, Edgs);
    [shape_springs] = warp_shape_springs(Edgs, shape_springs, SF);

    [Edgs, S, iter, plotE] = relax_edges(S, Edgs, R.region_info.order, extern_iter, extern_spr_const, animate_edge, axis_handle, error_axis_handle, shape_springs);

    [shape] = warp_organ_shape(Edgs, S, UngrowthData{i}.Edgs, UngrowthData{i}.S, UngrowthData{i}.order, UngrowthData{i}.shape, REGS);
    [control_pts] = warp_control_pts(Edgs, S, UngrowthData{i}.Edgs, UngrowthData{i}.S, UngrowthData{i}.order, UngrowthData{i}.control_pts, REGS);
    if recalc_flag
        [region_rot_mat] = calc_strain_cross_matrix(UngrowthData{i}.control_pts, control_pts, REGS);
        fprintf(' - rotating tensors for stages %0.2d - %0.2d\n', i, num_growth_stages);
        for j=i+1:num_growth_stages
            growth_params.scaling_factors{j}.theta = growth_params.scaling_factors{j}.theta - region_rot_mat;
        end
    end
    cla(axis_handle);
    display_grid(S, Edgs, R.region_info.order, axis_handle, [1 0 0], 2);
    display_edges(S, Edgs, axis_handle);
    display_springs(S, axis_handle, 0);
    display_shape_springs(S, Edgs, shape_springs);
    display_organ_shape(shape, axis_handle, [1 0 0], 2);
    drawnow;
end
N =num_growth_stages+1;
UngrowthData{N}.S = S;
UngrowthData{N}.Edgs = Edgs;
UngrowthData{N}.order = R.region_info.order;
UngrowthData{N}.edge_petal = edge_petal;
UngrowthData{N}.shape = shape;
UngrowthData{N}.control_pts = control_pts;
UngrowthData{N}.REGS = REGS;
UngrowthData{N}.SF = SF;
return;
