function [p, q, theta, psi, rot] = TranMat2CrossStrain(A)
a=A(1,1);
b=A(1,2);
c=A(2,1);
d=A(2,2);
t=sqrt((a+d)^2 + (b-c)^2);
w=sqrt((a-d)^2 + (b+c)^2);
tho=(atan2((b+c),(a-d)))*180/pi;
omeg=(atan2((b-c),(a+d)))*180/pi;

if tho<0,
   tho=360+tho;
end;
if omeg<0,
   omeg=360+omeg;
end;

p=(t+w)/2;
q=(t-w)/2;
theta=(tho-omeg)/2;
psi=(tho+omeg)/2;

if theta >90,
   if theta<270,
      theta=theta-180;
   elseif theta>270,
      theta=theta-360;
   end;
elseif theta <-90,
   theta=theta+180;
end;

if psi >90,
   if psi<270,
      psi=psi-180;
   elseif psi>270,
      psi=psi-360;
   end;
elseif psi<-90,
   psi=psi+180;
end;
rot = -mod(180, psi-theta);
