    
function [] = make_sectors_xy()
files = FindFilenames('sectors.tif',pwd);
for f = 1:length(files)
    file = files{f};
    I = imread(file);
    [path, file, ext, vers] = fileparts(file);
    file = file(1:end-8);
    binim = imread([path, filesep, file, '_organ.tif']);
    I = I./max(I(:));
    I = logical(I);
    I = I.*binim;
    [x, y] = find(I>0);
    sectors = [x(:), y(:)];
    save([path, filesep, 'sectors_xy.mat'], 'sectors');
    imwrite(I, [path, filesep, file, '_sectors.tif'], 'TIFF');
    fprintf('%d of %d: %s\n', f, length(files), file);
end