% [selection,value] = SelectFilesUI(varargin)
%
% This little tool allows you to select multiple directories (except those
% with '.' at the front.
%
% 
% Dr. A. I. Hanna
function [selection,value] = SelectFilesUI(varargin)
error(nargchk(0,inf,nargin))
fig = openfig(mfilename, 'reuse');
Data.handles = guihandles(fig);
Data.handles.figMain = fig;
currentlistbox = Data.handles.CurrentDirectoriesList;
files = dir;
set(currentlistbox, 'string', {files.name});
set(Data.handles.OkBtn, 'callback', {@doOk, currentlistbox, Data.handles.SelectedDirectoriesList});
set(Data.handles.CancelBtn, 'callback', {@doCancel, currentlistbox});
set(Data.handles.SelectAllBtn, 'callback', {@doSelectAll, currentlistbox});
set(Data.handles.CurrentDirectoriesList,'callback',{@doListboxClick, Data.handles.SelectAllBtn});
set(Data.handles.DoneBtn, 'callback', {@doDone, Data.handles.SelectedDirectoriesList});
set([fig,currentlistbox,Data.handles.OkBtn,Data.handles.CancelBtn], 'keypressfcn', {@doKeypress, currentlistbox})
% make sure we are on screen
movegui(fig, 'center')
set(fig, 'visible','on');
ad.currentpath = pwd;
ad.value = 0;
ad.selection = [];
setappdata(0,'ListDialogAppData',ad)
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
if isappdata(0,'ListDialogAppData')
    ad = getappdata(0,'ListDialogAppData');
    selection = ad.selection;
    value = ad.value;
    rmappdata(0,'ListDialogAppData')
else
    % figure was deleted
    selection = [];
    value = 0;
end


function doCancel(cancel_btn, evd, listbox)
ad.value = 0;
ad.selection = [];
setappdata(0,'ListDialogAppData',ad)
delete(gcbf);

function doSelectAll(selectall_btn, evd, listbox)
set(selectall_btn,'enable','off')
set(listbox,'value',1:length(get(listbox,'string')));

function doKeypress(fig_h, evd, listbox)
switch evd.Key
    case {'return','space'}
        doOk([],[],listbox);
    case 'escape'
        doCancel([],[],listbox);
end


function doListboxClick(listbox, evd, selectall_btn)
% if this is a doubleclick, doOK
ap = getappdata(0,'ListDialogAppData');
currentpath = ap.currentpath;
selected = get(listbox,'value');
str = get(listbox, 'String');
if strcmp(get(gcbf,'SelectionType'),'open')
    if isempty(findstr('.',char(str(selected(1)))))==1
        directory=['''' char(str(selected(1))) ''''];
        if isdir([currentpath, filesep, str{selected(1)}])
            currentpath = [currentpath, filesep, str{selected(1)}];
        end
        %eval(['cd ', directory]);
    elseif (selected(1) == 1) | (selected(1) == 2)
        currentpath =fileparts(currentpath);
        %cd ..
    else
        doOK([],[],listbox);
    end
    files = dir(currentpath);
    set(listbox, 'string', {files.name});
    set(listbox, 'value', 1);
elseif nargin == 3
    if length(get(listbox,'string'))==length(get(listbox,'value'))
        set(selectall_btn,'enable','off')
    else
        set(selectall_btn,'enable','on')
    end
end
ap.currentpath = currentpath;
setappdata(0,'ListDialogAppData',ap)

function doDone(ok_btn, evd, listbox)
ad.value = 1;
ad.selection = get(listbox,'String');
setappdata(0,'ListDialogAppData',ad)
delete(gcbf);

function doOk(ok_btn, evd, listbox, selectedListbox)
ap = getappdata(0,'ListDialogAppData');

ad.value = 1;
ad.selection = get(listbox,'value');

str = get(listbox, 'String');
selectedDirsStr = get(selectedListbox, 'String');
str = {str{ad.selection}};
ind = [];
for i=1:length(str)
    file = str{i};
   if ~isdir([ap.currentpath, filesep, file]) |strcmp('.', file(1))
    ind = [ind; i];
   end
end
str(ind) = [];
set(selectedListbox, 'String', str);