function [bw4] = ErikaCellPlanes(I)

    % not necessary, just to make a new handle and because I'm rubbish at
    % programming; 
    function fhandle = handlestruc
        fhandle.struc = [];
    end

    f = figure('Visible','off','Position',[800, 800, 1000,1000]);
    ha = axes('Units','pixels','Position',[100, 100, 800, 800]); 

    I_cropped = I;
    subplot(1,2,1), imshow(I_cropped);   
    title('The original image');
    hold on;

    I_grey = rgb2gray(I);
    PSF = fspecial('gaussian',5,1);
    Bl = imfilter(I_grey,PSF,'conv');
    I2 = imtophat(Bl, strel('disk', 3));
    level = graythresh(I2);
    bw4 = im2bw(I2,level);
    fhandle.bw4 = bw4;
    subplot(1,2,2), imshow(bw4); title('The segmented image. Happy?');
    hold on;
    
    % set the GUI buttons programatically;
    hsldbox   = uicontrol('Style','edit',...
             'Position',[350, 870, 100, 20],...
             'Value', 0.1, 'Max', 0.44, 'Min', 0, ...
            'Callback',{@sldbox_callback}); 
    hboxtext = uicontrol('Style', 'text',...
              'Position', [350, 900, 300, 40], 'String', 'Specify value between 0 and 1 to adjust the image for cell planes calculations.') ; 
    hlastval = uicontrol('Style', 'text',...
              'Position', [350, 950, 300, 20], 'String', sprintf('The last value was %1.5f .', level)) ;     
%%
    % the initialisation of the GUI
    fhandle.Icropped = I_cropped;
    % this ensures that when rescaling the GUI window, the figure and
    % buttons are also rescaled. 
    set([f, hsldbox, hboxtext, hlastval],'Units','normalized');
    set(f,'Name',['Sector Extraction'])
    movegui(f,'center')
    set(f,'Visible','on')


%%
       
        function sldbox_callback(source, eventsdata) % get the entred threshold
          % get entered value;
            input = str2num(get(hsldbox,'String'));
         % checks if value was entered, if not sets value to 0.001;
            if (isempty(input))
                set(hsldbox,'String','0.001')
            end

            I_grey = rgb2gray(I_cropped);
            PSF = fspecial('gaussian',5,1);
            Bl = imfilter(I_grey,PSF,'conv');
            I2 = imtophat(Bl, strel('disk', 3));
            bw4 = im2bw(I2,input); % maybe adjust as not so good at the moment (too high)       
            fhandle.bw4 = bw4;
            subplot(1,2,2), imshow(bw4); title('The extracted division planes of the original image');
        end
  
waitfor(f); % remain in this function until the GUI window is closed;   
bw4 = fhandle.bw4;
return
end
