function [smooth_growth_parameters] = smooth_growth_parameters(growth_parameters, neighbours)
% function [smooth_growth_parameters] = smooth_growth_parameters(growth_parameters, neighbours)
%
% Take the average of the current regions growth tensor with those of its
% neighbours
%
% Dr. A. I. Hanna (2007)
smooth_growth_parameters = growth_parameters;
for i=1:size(neighbours,1)
    ind = neighbours(i,:);
    for ii = 1:length(growth_parameters)
        G = growth_parameters{ii};
        smooth_growth_parameters{ii}(:,:,i) = mean(cat(3, G(:,:,ind), G(:,:,i)),3);
    end
end
return;