function [ungrowth_tensors] = check_principal_directions(ungrowth_tensors)
% function [ungrowth_tensors] = check_principal_directions(ungrowth_tensors)
%
% Takes a cell array where each element corresponds to a stage of ungrowth
% and contains a 3x3xN matrix where N is the number of regions on the
% organ. For each of the growth tensors, the principal direction of growth
% is 
if isempty(ungrowth_tensors)
    return;
end
num_stages = length(ungrowth_tensors);
num_regions = size(ungrowth_tensors{1},3);

for i=1:num_stages
   for j=1:num_regions
      T =  ungrowth_tensors{i}(:,:,j);
      T = checkTensor(T);
   end
end
%%%
%
%%%
function T = checkTensor(T)
[smax, smin, theta] = gtlib_growthTensor2Params(T);
if smax<smin
    scratch = smax;
    smax = smin;
    smin = scratch;
    theta = theta + pi/2;
    T = gtlib_growthParams2Tensor(smax, smin, theta);
end  
return