function Export2FEMGrowthTool()



dataDir = [pwd, filesep, 'Staged\Data'];
femdir = [dataDir, filesep, 'FEMGrowthData', filesep];
if ~exist(femdir, 'dir') 
    mkdir(femdir); 
end

[data, ungrown_grids] = getUngrowthData(dataDir);
if isempty(data)
    return;
end
[filename, pathname] = uiputfile('*.mat', 'Save as...', [femdir, filesep, 'fem_', data.grid_name] );
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel');
    return;
end
savefemdir = [pathname, filesep, filename];

%mature_grid = ungrown_grids{1};
%[T, tri_pts, T_region_id] = grid2triangulation(mature_grid);




ungrown_grids = data.ungrown_grids;
GROWTHSTRUCT = [];
num_stages = length(ungrown_grids);
%t = data.ungrowth_params.stage_delta_t;
t = 20;
fprintf('Using %3.3f as the number of hours between stages\n', t);
figh = figure;
axish = gca;
for i=1:num_stages-1
    %stage_tensors = ungrowth_tensors{i}; 
    curr_grid = ungrown_grids{num_stages-i+1};
    
    stage_tensors = curr_grid.ungrowth_tensors; 
    %curr_grid = ungrown_grids{num_stages-i+2};
    %curr_grid = ungrown_grids{num_stages-i+2};
    %tri_info = zeros(size(stage_tensors,3), 3);
    tri_pts = curr_grid.tri_info.pts;
    T = curr_grid.tri_info.T;
    tri_info = zeros(size(T,1), 3);
    region_tri_ind = curr_grid.region_tri_ind;
    for j=1:length(region_tri_ind)
        r_ind = region_tri_ind{j};
        region_tensor = stage_tensors(:,:,j);
        [Smaj, Smin, theta] = gtlib_growthTensor2Params(region_tensor);
        Rmaj = log2(Smaj)/t;
        Rmin = log2(Smin)/t;
        tri_info(r_ind,:) = ones(length(r_ind),1)*[Rmaj, Rmin, theta];
    end
   % tri_pts = [curr_grid.control_pts; curr_grid.centroids];
%     for j=1:size(T,1)
%        region_tensor = stage_tensors(:,:,T_region_id(j));
%        [smax, smin, theta] = gtlib_growthTensor2Params(region_tensor);
%        
%        % to see why rate_x = log2(smax)/t please 
%        % see "Understanding the growth tensor", A. I. Hanna available at
%        % www.cmp.uea.ac.uk/~aih goto Publications then scroll down to Notes
%        rate_x = log2(smax)/t;
%        rate_y = log2(smin)/t;
%     
%        
%        tri_info(j,:) = [rate_x, rate_y, theta];
%     end
    cla(axish); 
    hold(axish, 'on');
    triplot(T, tri_pts(:,1), tri_pts(:,2), 'parent', axish);
    axis(axish, 'image', 'ij');
    pause(.1);
    drawnow;
    GROWTHSTRUCT(end+1).vertices = tri_pts;
    GROWTHSTRUCT(end).tri = T;
    GROWTHSTRUCT(end).tridata = tri_info;
end

curr_grid = ungrown_grids{1};
 
tri_pts = curr_grid.tri_info.pts;
%tri_pts = [curr_grid.control_pts; curr_grid.centroids];
GROWTHSTRUCT(end+1).vertices = tri_pts;
GROWTHSTRUCT(end).tri = T;
GROWTHSTRUCT(end).tridata = [];
close(figh);
save(savefemdir, 'GROWTHSTRUCT');
return;
%%%
%
%%%
function [l, G] = getUngrowthData(DataDir)
l =[];
G =[];
[filename, pathname] = uigetfile('*.mat', 'Pick some ungrowth data', [DataDir, filesep, 'UngrowthData', filesep]);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(pathname, filename)]);
    l = load(fullfile(pathname, filename));
    G = l.ungrown_grids;
end